/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class JobAndActivityDetector
implements SanityCheckDetectorBase {
    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(Codes.values()).map(InfoMessage.MessageCode::getCode).collect(Collectors.toList()))) {
            return messages;
        }
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        if (!exclusionList.contains(Codes.WARN_JOBS_MAX_TOO_HIGH.getCode()) && generalSettings.jekSettings.maxRunningJobs >= 100) {
            messages.withTrustedHTMLV(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_JOBS_MAX_TOO_HIGH, "The max jobs value is high: %s. This may reduce performance if too many jobs run concurrently and if the instance is not correctly sized.", new String[]{Integer.toString(generalSettings.jekSettings.maxRunningJobs)});
        }
        if (!exclusionList.contains(Codes.WARN_JOBS_NO_LIMIT.getCode()) && generalSettings.jekSettings.maxRunningJobs == 0 && generalSettings.maxRunningActivities == 0) {
            messages.withTrustedHTMLV(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_JOBS_NO_LIMIT, "There is no limit in the number of jobs. This may reduce performance if too many jobs run concurrently and if the instance is not correctly sized.", new String[]{Integer.toString(generalSettings.jekSettings.maxRunningJobs)});
        }
        if (!exclusionList.contains(Codes.WARN_JOBS_MAX_OVER_MAX_ACTIVITIES.getCode()) && generalSettings.maxRunningActivities > 0 && generalSettings.jekSettings.maxRunningJobs > generalSettings.maxRunningActivities) {
            messages.withTrustedHTMLV(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_JOBS_MAX_OVER_MAX_ACTIVITIES, "The max number of jobs is over the max number of activities and will be limited by to %s.", new String[]{Integer.toString(generalSettings.maxRunningActivities)});
        }
        return messages;
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_JOBS_MAX_TOO_HIGH("Jobs - Max value too high", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_JOBS_NO_LIMIT("Jobs - No limits set", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_JOBS_MAX_OVER_MAX_ACTIVITIES("Jobs - Max jobs is over max activities", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

