/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios.postactions;

import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.scenarios.postactions.PostScenarioAction;
import com.dataiku.dip.server.services.ProjectsUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;

public class CompressScenarioLogs
extends PostScenarioAction {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.scenarios.postactions.logs");

    public CompressScenarioLogs(ScenarioRun scenarioRun) {
        super(scenarioRun);
    }

    @Override
    public void run() throws Exception {
        logger.debug((Object)("Executing scenario post-action " + this.getClass().getSimpleName()));
        Params p = ProjectsUtils.getProjectDKUPropertiesAsParamsWithSystemOverrideEvenIfProjectDoesNotExist_AutoTXN(this.projectKey);
        if (!p.getBoolParam("dku.scenarios.postActions.compressScenarioLogs.enabled", true)) {
            logger.info((Object)"Not compressing scenario logs (requested by project property)");
            return;
        }
        long minSizeForScenarioLogCompressionKB = p.getLongParam("dku.scenarios.postActions.compressScenarioLogs.minSizeForScenarioLogCompressionKB", 500L);
        final long minSizeForStepLogCompressionKB = p.getLongParam("dku.scenarios.postActions.compressScenarioLogs.minSizeForStepLogCompressionKB", 200L);
        File scenarioLog = ScenarioRunContext.getLog(this.scenarioRun);
        if (minSizeForScenarioLogCompressionKB > 0L && scenarioLog.isFile() && scenarioLog.length() > minSizeForScenarioLogCompressionKB * 1024L) {
            logger.debugV("Compressing too large scenario %s - %d kb (limit %d kb)", new Object[]{scenarioLog.getName(), scenarioLog.length() / 1024L, minSizeForScenarioLogCompressionKB});
            DKUFileUtils.gzCompress((File)scenarioLog);
        }
        if (minSizeForStepLogCompressionKB > 0L) {
            File scenarioRunFolder = ScenarioRunContext.scenarioRunFolder(this.scenarioRun);
            Files.walkFileTree(scenarioRunFolder.toPath(), Collections.emptySet(), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (FlowJobUtils.LOCALCONFIG_FOLDER_NAME.equals(dir.toFile().getName())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attr) throws IOException {
                    if (attr.isRegularFile() && CompressScenarioLogs.this.isLogFileToCompress(path.toFile())) {
                        File logFile = path.toFile();
                        logger.trace((Object)("Compressible file " + logFile.getAbsolutePath() + " of size " + logFile.length()));
                        if (logFile.length() > minSizeForStepLogCompressionKB * 1024L) {
                            logger.debugV("Compressing too large step log file: %s - %d kb (limit %d kb)", new Object[]{logFile, logFile.length() / 1024L, minSizeForStepLogCompressionKB});
                            DKUFileUtils.gzCompress((File)logFile);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private boolean isLogFileToCompress(File file) {
        String fileName = file.getName();
        return fileName.startsWith("step_") && fileName.endsWith(".log") || "script.log".equals(fileName);
    }
}

