/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports.pmml.models.classification.binary;

import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.scoring.exports.pmml.XML;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLSegmentations;
import com.dataiku.dip.scoring.exports.pmml.helpers.PMMLTransformationDictionary;
import com.dataiku.dip.scoring.exports.pmml.models.PMMLModel;
import com.dataiku.dip.scoring.exports.pmml.models.classification.PMMLClassifier;
import com.dataiku.dip.scoring.exports.pmml.models.regression.PMMLRegressionModel;
import com.dataiku.scoring.models.Classifier;
import com.dataiku.scoring.pipelines.BinaryProbabilisticPipeline;
import com.dataiku.scoring.pipelines.ClassificationPipeline;
import java.util.ArrayList;

public abstract class PMMLBinaryClassifier
extends PMMLClassifier {
    @XML.Element
    PMMLSegmentations.PMMLModelChainSegmentation Segmentation = new PMMLSegmentations.PMMLModelChainSegmentation();

    public PMMLBinaryClassifier(BinaryProbabilisticPipeline pipe, ResolvedPredictionPreprocessingParams rppp, boolean sigmoidNormalization) {
        super((ClassificationPipeline)pipe, rppp);
        ArrayList<PMMLSegmentations.PMMLSegment> segmentations = new ArrayList<PMMLSegmentations.PMMLSegment>();
        PMMLSegmentations.PMMLModelSegment modelSegment = new PMMLSegmentations.PMMLModelSegment();
        segmentations.add(modelSegment);
        PMMLSegmentations.PMMLRegressionSegment thresholdSegment = new PMMLSegmentations.PMMLRegressionSegment();
        thresholdSegment.RegressionModel = new PMMLThresholdModel(pipe, sigmoidNormalization);
        segmentations.add(thresholdSegment);
        this.Segmentation.Segment = segmentations;
    }

    public void setModel(PMMLBinaryModel model) {
        ((PMMLSegmentations.PMMLModelSegment)this.Segmentation.Segment.get((int)0)).MiningModel = model;
    }

    public static class PMMLThresholdModel
    extends PMMLRegressionModel {
        @XML.Attribute
        final String functionName = "classification";
        @XML.Attribute
        final String normalizationMethod;

        public PMMLThresholdModel(BinaryProbabilisticPipeline pipe, boolean sigmoidNormalization) {
            this.normalizationMethod = sigmoidNormalization ? "logit" : "none";
            String[] classes = pipe.getClasses();
            ArrayList<PMMLModel.PMMLMiningSchema.PMMLMiningField> fields = new ArrayList<PMMLModel.PMMLMiningSchema.PMMLMiningField>(1);
            fields.add(new PMMLModel.PMMLMiningSchema.PMMLMiningField("prediction_" + classes[1]));
            this.MiningSchema = PMMLModel.PMMLMiningSchema.fromFields(fields);
            this.Output = PMMLModel.PMMLOutput.binaryClassification(pipe.getClasses(), pipe.getThreshold(), sigmoidNormalization);
            ArrayList<PMMLRegressionModel.PMMLLogisticRegressionTable> regressionTables = new ArrayList<PMMLRegressionModel.PMMLLogisticRegressionTable>(2);
            regressionTables.add(new PMMLRegressionModel.PMMLLogisticRegressionTable(classes[1], 0.0, new double[]{1.0}, new String[]{"prediction_" + classes[1]}));
            regressionTables.add(new PMMLRegressionModel.PMMLLogisticRegressionTable(classes[0]));
            this.RegressionTable = regressionTables;
        }
    }

    public static class PMMLBinaryModel
    extends PMMLClassifier {
        public PMMLBinaryModel(ClassificationPipeline pipe, ResolvedPredictionPreprocessingParams rppp) {
            super(pipe, rppp);
        }

        @Override
        public void enrichTransformationDictionaryFromModel(PMMLTransformationDictionary dictionary, String[] colNames, Classifier model) {
        }
    }
}

