/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.ModelComparisonSampleDataService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.mec.ModelComparisonsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.codec.digest.DigestUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ModelComparisonsController
extends DIPInternalControllerBase {
    @Autowired
    private ModelComparisonsService modelComparisonsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ModelComparisonSampleDataService modelComparisonSampleDataService;
    @Autowired
    private FutureService futureService;
    public static final int DEFAULT_MAX_COMPARABLE_LIST_LENGTH = 1000;
    public static final String DKU_MAX_COMPARABLE_LIST_LENGTH = "dku.max.comparable_list.length";

    @AuditedCall(value={"msgType", "modelcomparisons-browse-comparables", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/modelcomparisons/browse-comparables"}, method={RequestMethod.GET})
    @ResponseBody
    public BrowseableComparables browseComparableItems(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false) ModelComparisonsService.MELikesSource source, @RequestParam(required=false) ModelComparison.ModelTaskType modelTaskType, @RequestParam(required=false) List<String> versions) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        BrowseableComparables ret = new BrowseableComparables();
        int maxComparables = DKUApp.getProperty((String)DKU_MAX_COMPARABLE_LIST_LENGTH, (int)1000);
        ret.comparableModelItems = this.modelComparisonsService.listFilteredComparableItems(projectKey, (List<ModelComparisonsService.MELikesSource>)(source == null ? null : ImmutableList.of((Object)((Object)source))), modelTaskType, true, versions, ret.infoMessages, maxComparables);
        return ret;
    }

    @AuditedCall(value={"msgType", "modelcomparisons-get-models-details", "fullIds", "${fullIds}"})
    @RequestMapping(value={"/api/modelcomparisons/get-details"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ModelComparisonsService.AbstractComparableItemDetails> getModelDetails(HttpServletRequest req, @RequestParam List<String> fullIds) throws Exception {
        List<ModelLikeId> modelLikeIds = fullIds.stream().map(fullId -> ModelLikeId.parse(fullId, null)).collect(Collectors.toList());
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (ModelLikeId modelLikeId : modelLikeIds) {
                ITaggingService.TaggableType type = modelLikeId.getModelLikeType() == ModelLikeId.ModelLikeType.DOCTOR_MODEL ? ITaggingService.TaggableType.SAVED_MODEL : ITaggingService.TaggableType.MODEL_EVALUATION_STORE;
                SmartObjectRef ref = SmartObjectRef.fromResolved(type, modelLikeId.getProjectKey(), modelLikeId.getUnderlyingStore().id, modelLikeId.getProjectKey());
                this.projectsService.failIfNoDashboardReadPermission(authCtx, ref, modelLikeId.getProjectKey());
            }
        }
        return this.modelComparisonsService.getComparableItemDetails_NT(modelLikeIds);
    }

    public static FuturePayload buildFuturePayload(List<FullModelEvaluationId> fmeIds) {
        FuturePayload fp = new FuturePayload();
        fp.action = "refresh_model_comparison_sample";
        fp.targets.add(DSSFuturePayloadUtils.forFMEs(fmeIds).withPart("sample"));
        fp.displayName = "Refreshing model comparison sample values table";
        return fp;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/modelcomparisons/llm/sample/get-schema"}, method={RequestMethod.POST})
    @ResponseBody
    public Schema getSampleSchema(HttpServletRequest req, @RequestParam String projectKey, @RequestParam List<String> fmeIds) throws Exception {
        List<FullModelEvaluationId> parsedFmes = fmeIds.stream().map(FullModelEvaluationId::parse).collect(Collectors.toList());
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.modelComparisonSampleDataService.getSampleSchema(parsedFmes);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/modelcomparisons/llm/sample/refresh-table"}, method={RequestMethod.POST})
    public void refreshTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelComparisonId, @RequestParam List<String> fmeIds, @RequestParam String displayScript, @RequestParam(value="filters", required=false, defaultValue="") String filters) throws Exception {
        AuthCtx user;
        List<FullModelEvaluationId> parsedFmeIds = fmeIds.stream().map(FullModelEvaluationId::parse).collect(Collectors.toList());
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        RefreshTableFutureThread ft = new RefreshTableFutureThread((DSSAuthCtx)user, projectKey, modelComparisonId, parsedFmeIds, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
        ModelComparisonsController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<ModelComparisonSampleResult>>(){}));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/modelcomparisons/llm/sample/get-table-chunk"})
    public void getTableChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelComparisonId, @RequestParam List<String> fmeIds, @RequestParam String displayScript, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam int firstCol, @RequestParam int nbCols, @RequestParam String filters) throws Exception {
        List<FullModelEvaluationId> parsedFmeIds = fmeIds.stream().map(FullModelEvaluationId::parse).collect(Collectors.toList());
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ModelComparisonChunkResult result = new ModelComparisonChunkResult();
        MemScriptRunner.TableWithReport twr = this.modelComparisonSampleDataService.getUncachedFiltered_NT(projectKey, modelComparisonId, parsedFmeIds, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
        result.chunkWithSelectedColumns = new SerializedTableChunk(firstRow, nbRows, firstCol, nbCols);
        result.chunkWithSelectedColumns.fill(twr.table, twr.filters, sss.coloring, sss.columnsSelection);
        sss.columnsSelection.mode = SerializedShakerScript.DisplayedColumnsMode.ALL;
        result.fullChunk = new SerializedTableChunk(firstRow, nbRows, 0, twr.initialCols);
        result.fullChunk.fill(twr.table, twr.filters, sss.coloring, sss.columnsSelection);
        ModelComparisonsController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/modelcomparisons/llm/sample/detailed-column-analysis"})
    public void detailedColumnAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelComparisonId, @RequestParam List<String> fmeIds, @RequestParam String data, @RequestParam String column, @RequestParam int alphanumMaxResults) throws Exception {
        List<FullModelEvaluationId> parsedFmeIds = fmeIds.stream().map(FullModelEvaluationId::parse).collect(Collectors.toList());
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ShakerUtils.checkScriptCodePermission(user, ss);
        }
        ModelComparisonsController.writeJSON((HttpServletResponse)resp, (Object)this.modelComparisonSampleDataService.getDetailedColumnAnalysis(projectKey, modelComparisonId, parsedFmeIds, ss, column, alphanumMaxResults));
    }

    public static class BrowseableComparables {
        public List<ModelComparisonsService.ComparableModelItem> comparableModelItems = Lists.newArrayList();
        public InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
    }

    class RefreshTableFutureThread
    extends FutureThread<ModelComparisonSampleResult> {
        final String projectKey;
        final String modelComparisonId;
        final List<FullModelEvaluationId> fmeIds;
        final SerializedShakerScript displayScript;
        final FilterRequest frequest;
        final FuturePayload futurePayload;
        ModelComparisonSampleResult result;

        public RefreshTableFutureThread(DSSAuthCtx user, String projectKey, String modelComparisonId, List<FullModelEvaluationId> fmeIds, SerializedShakerScript sss, FilterRequest filterRequest) {
            super(user);
            this.result = new ModelComparisonSampleResult();
            this.projectKey = projectKey;
            this.modelComparisonId = modelComparisonId;
            this.fmeIds = fmeIds;
            this.displayScript = sss;
            this.frequest = filterRequest;
            this.futurePayload = ModelComparisonsController.buildFuturePayload(fmeIds);
        }

        public ModelComparisonSampleResult getResult() {
            return this.result;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            String fmeIdsJoined = this.fmeIds.stream().map(FullModelEvaluationId::toString).collect(Collectors.joining(", "));
            NDC.push((String)("refresh-sample-table: " + this.modelComparisonId + ", model evaluations :" + DigestUtils.md5Hex((String)fmeIdsJoined)));
            DIPInternalControllerBase.logger.info((Object)("FME Ids : " + fmeIdsJoined));
            try {
                MemScriptRunner.TableWithReport twr = ModelComparisonsController.this.modelComparisonSampleDataService.getUncachedFiltered_NT(this.projectKey, this.modelComparisonId, this.fmeIds, this.displayScript, this.frequest);
                this.result.tableWithSelectedColumns.fill(twr, this.displayScript, 64, 32);
                this.displayScript.columnsSelection.mode = SerializedShakerScript.DisplayedColumnsMode.ALL;
                this.result.fullTable.fill(twr, this.displayScript, 64, Integer.MAX_VALUE);
            }
            catch (Exception e) {
                DIPInternalControllerBase.logger.error((Object)"Failed to get table data", (Throwable)e);
                throw e;
            }
            finally {
                NDC.pop();
            }
        }
    }

    static class ModelComparisonChunkResult {
        SerializedTableChunk chunkWithSelectedColumns;
        SerializedTableChunk fullChunk;
    }

    static class ModelComparisonSampleResult {
        final SerializedMemTableV2 tableWithSelectedColumns = new SerializedMemTableV2();
        final SerializedMemTableV2 fullTable = new SerializedMemTableV2();
    }
}

