/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.EditableDatasetConfig;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.inline.InlineDatasetConfig;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.datasets.EditableDatasetProcessorOutput;
import com.dataiku.dip.server.datasets.FileUploadService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class EditableDatasetImporter {
    @Autowired
    private DatasetSaveService saveService;
    @Autowired
    private DatasetAccessService accessService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    private final AuthCtx authCtx;
    private final String contextProjectKey;
    private final InlineDatasetConfig config;
    private final String formatType;
    private final FormatParams formatParams;
    private final boolean postDatasetCreation;
    private static final int MAX_NUMBER_OF_ROWS = 100000;
    private static final int MAX_NUMBER_OF_COLS = 1000;
    private static final int MAX_IMPORTED_FILE_SIZE = 0x500000;

    public EditableDatasetImporter(AuthCtx authCtx, String contextProjectKey, InlineDatasetConfig config, String formatType, FormatParams formatParams, boolean postDatasetCreation) {
        this.authCtx = authCtx;
        this.contextProjectKey = contextProjectKey;
        this.config = config;
        this.formatType = formatType;
        this.formatParams = formatParams;
        this.postDatasetCreation = postDatasetCreation;
        SpringUtils.getInstance().autowire((Object)this);
    }

    /*
     * Unable to fully structure code
     */
    public void import_NT(Dataset target) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        dh = DatasetHandlerFactory.build(this.authCtx, target);
        try {
            if (!(dh instanceof InlineDatasetHandler)) {
                throw ErrorContext.iaef((String)"Wrong dataset handler type, expected %s but got %s", (Object)InlineDatasetHandler.class.getSimpleName(), (Object[])new Object[]{dh.getClass().getSimpleName()});
            }
            idh = (InlineDatasetHandler)dh;
            type = this.config.importSourceType;
            switch (1.$SwitchMap$com$dataiku$dip$datasets$inline$InlineDatasetConfig$ImportSourceType[type.ordinal()]) {
                case 1: {
                    this.importEmpty_NT(idh);
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.importFromDataset_NT(idh);
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.importFromFile_NT(idh);
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                default: {
                    throw ErrorContext.iaef((String)"Unsupported import source type %s", (Object)type, (Object[])new Object[0]);
                }
            }
        }
        finally {
            if (dh != null) {
                dh.close();
            }
        }
        this.datasetDeletionService.clearCacheAndStatus_NT(target);
    }

    private void importEmpty_NT(InlineDatasetHandler targetDh) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            if (this.postDatasetCreation) {
                targetDh.initMetadata();
            }
            targetDh.clearAllData();
            Dataset target = targetDh.getDataset();
            this.saveService.saveWithoutEvents(target.getProjectKey(), target.getName(), target.serialize(), this.authCtx);
            t.commit(String.format("Saved empty content for dataset %s", target.getFullName()));
        }
    }

    private void importFromDataset_NT(InlineDatasetHandler targetDh) throws Exception {
        Dataset source;
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(this.contextProjectKey, this.config.importDatasetSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.failIfNoDatasetReadUseAccess(this.authCtx, loc, this.contextProjectKey);
            source = this.accessService.getMandatory(loc);
        }
        this.importContent_NT(source, targetDh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromFile_NT(InlineDatasetHandler targetDh) throws Exception {
        File inputDir = FileUploadService.uploadBoxDir(this.config.uploadBoxId);
        try {
            long size = FileUtils.sizeOf((File)inputDir);
            if (this.config.importMode == InlineDatasetConfig.ImportMode.APPEND) {
                size += targetDh.getDataFileSize();
            }
            if (size > 0x500000L) {
                throw ErrorContext.iaef((String)"Editable datasets file size should not be more than %d.", (Object)0x500000, (Object[])new Object[0]);
            }
            FilesystemDatasetConfig fakeConfig = new FilesystemDatasetConfig(null, inputDir.getAbsolutePath());
            Dataset fakeSource = new Dataset();
            fakeSource.setFullName("fake.fake");
            fakeSource.setType("Filesystem");
            fakeSource.setParams(fakeConfig);
            fakeSource.setFormatType(this.formatType);
            fakeSource.setFormatParams(this.formatParams);
            Dataset target = targetDh.getDataset();
            fakeSource.setSchema(target.getSchema());
            this.importContent_NT(fakeSource, targetDh);
        }
        finally {
            if (inputDir.exists()) {
                DKUFileUtils.forceDelete((File)inputDir);
            }
        }
    }

    private void importContent_NT(Dataset source, InlineDatasetHandler targetDh) throws Exception {
        Transaction t;
        Schema schema;
        Dataset target = targetDh.getDataset();
        Schema schema2 = schema = this.config.importMode == InlineDatasetConfig.ImportMode.APPEND ? SchemaUtils.union(target.getSchema(), source.getSchema()) : source.getSchema();
        if (schema.columns.size() > 1000) {
            throw ErrorContext.iaef((String)"Editable datasets should not have more than %d columns.", (Object)1000, (Object[])new Object[0]);
        }
        SchemaUtils.checkSchema(schema);
        target.setSchema(schema);
        EditableDatasetProcessorOutput targetOutput = new EditableDatasetProcessorOutput(targetDh, 100000);
        if (this.config.importMode == InlineDatasetConfig.ImportMode.APPEND) {
            if (target.getParamsAs(EditableDatasetConfig.class).keepTrackOfChanges()) {
                t = this.transactionService.beginRead();
                try {
                    MemTable existingChanges = targetDh.getChangesAsMemTable();
                    this.pushContent(target, existingChanges, targetOutput);
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            } else {
                this.pushContent(target, null, targetOutput);
            }
        }
        this.pushContent(source, null, targetOutput);
        t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);
        try {
            if (this.postDatasetCreation) {
                targetDh.initMetadata();
            }
            SerializedDataset sds = target.serialize();
            sds.versionTag = VersionTag.increment(sds.versionTag, this.authCtx.getIdentifier());
            targetOutput.lastRowEmitted();
            this.saveService.save(target.getProjectKey(), target.getName(), sds, this.authCtx);
            t.commit(String.format("Imported content to editable dataset %s", target.getFullName()));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    private void pushContent(Dataset source, @Nullable MemTable sourceChanges, EditableDatasetProcessorOutput targetOutput) throws Exception {
        targetOutput.importChangesFrom(sourceChanges);
        boolean success = UniversalSingleThreadPusher.push(this.authCtx, source, targetOutput, targetOutput.cf, targetOutput.rf);
        if (!success) {
            throw new RuntimeException("Load to editable dataset not finished: dataset truncated!");
        }
    }
}

