/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.plugins.PluginConfigUtils;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.model.PluginCredentialRequestService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PluginPrivilegedIntercomController
extends DIPInternalControllerBase {
    @Autowired
    TicketAuthService ticketAuthService;
    @Autowired
    SharedSecretAuthService sharedSecretAuthService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/pintercom/plugins/get-fully-resolved-credentials"})
    public void getFullyResolvedCredentials(HttpServletRequest req, HttpServletResponse resp, @RequestParam String name, @RequestParam String label, @RequestParam PluginCredentialRequestService.PluginCredentialRequestInfo credentialRequestInfo) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            if (!this.sharedSecretAuthService.hasValidSharedSecret(req)) {
                throw new UnauthorizedException("You may not read details of plugin " + name, "plugin-details-denied");
            }
            PluginPrivilegedIntercomController.writeJSON((HttpServletResponse)resp, (Object)PluginConfigUtils.getFullyResolvedCredentials(tu.getAuthCtx(), name, label, credentialRequestInfo));
        }
    }
}

