/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.MarkupFormattersService;
import com.dataiku.dip.server.notifications.backend.CommitMentionEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionMentionEvent;
import com.dataiku.dip.server.notifications.backend.ExportStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.JobStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.MLTaskStateChangedEvent;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailNotificationsGatherer {
    private static final String NO_PROJECT = "$NO_PROJECT$";
    @Autowired
    ProjectsService projectsService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    MarkupFormattersService linksService;
    private Set<String> projects = new HashSet<String>();
    private Map<String, List<TimelineItem>> timelineItems = new HashMap<String, List<TimelineItem>>();
    private Map<String, List<JobStateChangedEvent>> jobs = new HashMap<String, List<JobStateChangedEvent>>();
    private Map<String, List<MLTaskStateChangedEvent>> mlTasks = new HashMap<String, List<MLTaskStateChangedEvent>>();
    private Map<String, List<ExportStateChangedEvent>> exports = new HashMap<String, List<ExportStateChangedEvent>>();
    private Map<String, List<CommitMentionEvent>> commitMentions = new HashMap<String, List<CommitMentionEvent>>();
    private Map<String, List<DiscussionMentionEvent>> discussionMentions = new HashMap<String, List<DiscussionMentionEvent>>();

    public EmailNotificationsGatherer() throws Exception {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void add(TimelineItem ti) {
        if (!this.timelineItems.containsKey(ti.projectKey)) {
            this.timelineItems.put(ti.projectKey, new ArrayList());
        }
        this.timelineItems.get(ti.projectKey).add(ti);
        this.projects.add(ti.projectKey);
    }

    public void add(JobStateChangedEvent evt) {
        String projectKey = evt.projectKey;
        if (!this.jobs.containsKey(projectKey)) {
            this.jobs.put(projectKey, new ArrayList());
        }
        this.jobs.get(projectKey).add(evt);
        this.projects.add(projectKey);
    }

    public void add(ExportStateChangedEvent evt) {
        String projectKey = NO_PROJECT;
        if (!this.exports.containsKey(projectKey)) {
            this.exports.put(projectKey, new ArrayList());
        }
        this.exports.get(projectKey).add(evt);
        this.projects.add(projectKey);
    }

    public void add(MLTaskStateChangedEvent evt) {
        String projectKey = evt.projectKey;
        if (!this.mlTasks.containsKey(projectKey)) {
            this.mlTasks.put(projectKey, new ArrayList());
        }
        this.mlTasks.get(projectKey).add(evt);
        this.projects.add(projectKey);
    }

    public void add(CommitMentionEvent me) {
        if (!this.commitMentions.containsKey(me.projectKey)) {
            this.commitMentions.put(me.projectKey, new ArrayList());
        }
        this.commitMentions.get(me.projectKey).add(me);
        this.projects.add(me.projectKey);
    }

    public void add(DiscussionMentionEvent me) {
        if (!this.discussionMentions.containsKey(me.projectKey)) {
            this.discussionMentions.put(me.projectKey, new ArrayList());
        }
        this.discussionMentions.get(me.projectKey).add(me);
        this.projects.add(me.projectKey);
    }

    public GroupedNotifications gather() throws Exception {
        GroupedNotifications ret = new GroupedNotifications();
        ArrayList projectsList = Lists.newArrayList(this.projects);
        Collections.sort(projectsList);
        for (String projectKey : projectsList) {
            if (NO_PROJECT.equals(projectKey)) {
                ret.noProject = this.makeProjectData(NO_PROJECT);
                continue;
            }
            ret.byProject.add(this.makeProjectData(projectKey));
        }
        return ret;
    }

    private ProjectData makeProjectData(String projectKey) throws Exception {
        ProjectData data = new ProjectData();
        MarkupFormatter links = this.linksService.getMarkupFormatter(Markup.HTML);
        if (!NO_PROJECT.equals(projectKey)) {
            try (Transaction t = this.transactionService.beginRead();){
                String string = this.projectsService.getMandatoryUnsafe((String)projectKey).name;
                data.projectName = links.project(projectKey, string);
                data.projectKey = projectKey;
            }
        }
        if (this.timelineItems.get(projectKey) != null) {
            for (TimelineItem timelineItem : this.timelineItems.get(projectKey)) {
                data.timelineItems.add(timelineItem.toHumanReadableString(links));
            }
        }
        if (this.jobs.get(projectKey) != null) {
            for (JobStateChangedEvent jobStateChangedEvent : this.jobs.get(projectKey)) {
                data.jobs.add(jobStateChangedEvent.toHumanReadableString(links));
            }
        }
        if (this.mlTasks.get(projectKey) != null) {
            for (MLTaskStateChangedEvent mLTaskStateChangedEvent : this.mlTasks.get(projectKey)) {
                data.mlTasks.add(mLTaskStateChangedEvent.toHumanReadableString(links));
            }
        }
        if (this.exports.get(projectKey) != null) {
            for (ExportStateChangedEvent exportStateChangedEvent : this.exports.get(projectKey)) {
                data.exports.add(exportStateChangedEvent.toHumanReadableString(links));
            }
        }
        if (this.commitMentions.get(projectKey) != null) {
            for (CommitMentionEvent commitMentionEvent : this.commitMentions.get(projectKey)) {
                data.mentions.add(commitMentionEvent.toHumanReadableString(links));
            }
        }
        return data;
    }

    public static class GroupedNotifications {
        public List<ProjectData> byProject = new ArrayList<ProjectData>();
        public ProjectData noProject;

        public List<ProjectData> getByProject() {
            return this.byProject;
        }

        public ProjectData getNoProject() {
            return this.noProject;
        }
    }

    public static class ProjectData {
        public String projectKey;
        public String projectName;
        public List<String> timelineItems = new ArrayList<String>();
        public List<String> jobs = new ArrayList<String>();
        public List<String> mlTasks = new ArrayList<String>();
        public List<String> exports = new ArrayList<String>();
        public List<String> mentions = new ArrayList<String>();

        public String getProjectKey() {
            return this.projectKey;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public List<String> getTimelineItems() {
            return this.timelineItems;
        }

        public List<String> getJobs() {
            return this.jobs;
        }

        public List<String> getExports() {
            return this.exports;
        }

        public List<String> getMentions() {
            return this.mentions;
        }

        public List<String> getMlTasks() {
            return this.mlTasks;
        }
    }
}

