/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.common.base.Preconditions;
import java.util.List;

public class DatasetChangedEvent
extends BackendEvent
implements ProjectEvent,
TaggableObjectEvent {
    public static final String NAME = "dataset-change";
    public final List<String> partitions;
    public final AnyLoc fullDatasetName;
    public final boolean isDeleted;

    public DatasetChangedEvent(AnyLoc fullDatasetName, List<String> partitions, boolean isDeleted) {
        this.fullDatasetName = (AnyLoc)Preconditions.checkNotNull((Object)fullDatasetName);
        this.partitions = (List)Preconditions.checkNotNull(partitions);
        this.isDeleted = isDeleted;
    }

    public DatasetChangedEvent(DatasetLocUtils.DatasetLoc fullDatasetName, List<String> partitions) {
        this(fullDatasetName, partitions, false);
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getProjectKey() {
        return this.fullDatasetName.getProjectKey();
    }

    @Override
    public TaggableObjectsService.TaggableObjectRef getTaggableObjectRef() {
        return new TaggableObjectsService.TaggableObjectRef(this.fullDatasetName.resolved().getProjectKey(), ITaggingService.TaggableType.DATASET, this.fullDatasetName.resolved().getId());
    }
}

