/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.backend.CodeEnvRequestEvent;
import com.dataiku.dip.server.notifications.emails.AbstractCodeEnvRequestEmailBuilder;

public class CodeEnvRequestEmailBuilder
extends AbstractCodeEnvRequestEmailBuilder<CodeEnvRequestEvent> {
    public CodeEnvRequestEmailBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    String makeSubject(CodeEnvModel.EnvLang envLanguage, PublicUser user, String objectDisplayName, String codeEnvTargetName) {
        return user.displayName + " requested a new " + this.capitalizedLanguage(envLanguage) + " code env";
    }

    @Override
    String makeMainText(CodeEnvModel.EnvLang envLanguage, PublicUser requesterUser) {
        return requesterUser.displayName + " requested a new " + this.capitalizedLanguage(envLanguage) + " code env";
    }

    @Override
    String makeTitle(String codeEnvTargetName) {
        return "Code Env Request";
    }

    @Override
    String makeRequestUrl(String requestId, String envName, CodeEnvModel.EnvLang codeEnvLanguage, String dssRootUrl) {
        HrefContext href = new HrefContext(dssRootUrl);
        return href.codeEnvRequest(requestId);
    }

    @Override
    String getCodeEnvTargetName(CodeEnvRequestEvent evt) {
        return null;
    }

    String capitalizedLanguage(CodeEnvModel.EnvLang envLang) {
        String languageInfo = envLang.getLanguageInfo();
        return languageInfo.substring(0, 1).toUpperCase() + languageInfo.substring(1);
    }
}

