/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ExceptionWithLogTail;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMAuditHelper;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMClientFactory;
import com.dataiku.dip.llm.online.NonParallelLLMClient;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LLMQuickTestService {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ComputeResourceUsageReportingService cruReportingService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.quicktest.service");

    @NotNull
    public LLMQuickTestResponse llmQuickTestCompletion(AuthCtx authCtx, String projectKey, LLMStructuredRef llmRef, String query) throws IOException, DKUSecurityException {
        LLMQuickTestResponse ret;
        block16: {
            LLMQuickTestCompletionQuery singleCompletionQuery = (LLMQuickTestCompletionQuery)JSON.parse((String)query, LLMQuickTestCompletionQuery.class);
            GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(authCtx, projectKey, llmRef);
            GuardrailsPipelineSettings usageTimeGuardrailsPipelineSettings = null;
            GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings(connectionGuardrailsPipelineSettings, usageTimeGuardrailsPipelineSettings);
            ret = new LLMQuickTestResponse();
            try (LLMClient llmClient = LLMClientFactory.get(authCtx, projectKey, llmRef, true);){
                EnrichedLLMStructuredRef enrichedLLMRef = llmClient.getEnrichedRef();
                List<LLMClient.SimpleCompletionResponseOrError> responses = null;
                try (NonParallelLLMClient nplc = new NonParallelLLMClient(authCtx, llmClient, guardrailsPipelineSettings, projectKey, null);){
                    responses = nplc.completeQueries(Lists.newArrayList((Object[])new LLMClient.SingleCompletionQuery[]{singleCompletionQuery}), singleCompletionQuery.settings);
                    ComputeResourceUsage cru = llmClient.getTotalCRU(ComputeResourceUsage.LLMUsageType.COMPLETION, enrichedLLMRef);
                    if (cru != null) {
                        cru.llmUsage.totalQueries = nplc.cacheHitQueries + nplc.cacheMissQueries;
                        cru.llmUsage.cacheHitQueries = nplc.cacheHitQueries;
                        cru.llmUsage.cacheMissQueries = nplc.cacheMissQueries;
                        this.cruReportingService.reportComplete(cru);
                    }
                    LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded(this.auditTrailService, enrichedLLMRef, llmClient.getConnection(), singleCompletionQuery, responses.get(0));
                }
                ret.response = responses.get(0);
                ret.fullTrace = ret.response.trace;
                if (ret.fullTrace != null && ret.fullTrace.children.size() > 2 && "DKU_LLM_MESH_LLM_CALL".equals(((LLMClient.LLMMeshTraceObservation)ret.fullTrace.children.get((int)1)).name) && !((LLMClient.LLMMeshTraceObservation)ret.fullTrace.children.get((int)1)).children.isEmpty()) {
                    ret.traceOfPython = (LLMClient.LLMMeshTraceSpan)((LLMClient.LLMMeshTraceObservation)ret.fullTrace.children.get((int)1)).children.get(0);
                }
                ret.response.trace = null;
                ret.log = llmClient.getKernelLog();
            }
            catch (Exception e) {
                logger.error((Object)"Test failed", (Throwable)e);
                ret.error = new SerializedError((Throwable)e, true);
                if (!(e instanceof ExceptionWithLogTail)) break block16;
                ret.error.logTail = ((ExceptionWithLogTail)e).getLogTail();
            }
        }
        return ret;
    }

    public static class LLMQuickTestCompletionQuery
    extends LLMClient.SingleCompletionQuery {
        public LLMClient.CompletionSettings settings = new LLMClient.CompletionSettings();
    }

    public static class LLMQuickTestResponse {
        public SerializedError error;
        public LLMClient.SimpleCompletionResponseOrError response;
        public LLMClient.LLMMeshTraceSpan fullTrace;
        public LLMClient.LLMMeshTraceSpan traceOfPython;
        public SmartLogTail log;
    }
}

