/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.services.catalog.TotalHitsCount;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.LabelAndValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LuceneResponseWrapper {
    public static final int MAX_TOTAL_HITS = DKUApp.getParams().getIntParam("dku.catalog.maxTotalHits", Integer.valueOf(1000));
    private static final Gson gson = new GsonBuilder().serializeNulls().create();
    public List<Hit> hits = new ArrayList<Hit>();
    public TotalHitsCount totalHits;
    public LinkedHashMap<String, Aggregation> aggregations = new LinkedHashMap();

    public String toString() {
        return "LuceneResponseWrapper{hits=" + String.valueOf(this.hits) + ", totalHits=" + String.valueOf(this.totalHits) + ", aggregations=" + String.valueOf(this.aggregations) + "}";
    }

    public void serializeJsonPayloads(Set<String> keysToSerialize) {
        for (Hit hit : this.hits) {
            for (String key : keysToSerialize) {
                if (!hit._source.containsKey("$json_" + key)) continue;
                JsonElement jsonElt = (JsonElement)gson.fromJson(hit._source.remove("$json_" + key).toString(), JsonElement.class);
                hit._source.put(key, jsonElt);
            }
        }
    }

    public String serializeHits() {
        return LuceneResponseWrapper.serializeHits(this.hits, this.totalHits, this.aggregations, false);
    }

    public static String serializeHits(List<Hit> hits, TotalHitsCount totalHits, LinkedHashMap<String, Aggregation> aggregations, Boolean isPagesSettingsController) {
        JsonObject rootJson = LuceneResponseWrapper.buildHits(hits, totalHits, isPagesSettingsController);
        if (!aggregations.isEmpty()) {
            rootJson.add("aggregations", (JsonElement)LuceneResponseWrapper.buildAggregations(aggregations));
        }
        return rootJson.toString();
    }

    private static JsonObject buildHits(List<Hit> hits, TotalHitsCount totalHits, boolean isPagesSettingsController) {
        JsonObject rootJson = new JsonObject();
        JsonArray hitsArray = new JsonArray();
        for (Hit searchHit : hits) {
            JsonObject hitJson = new JsonObject();
            if (!searchHit.highlight.isEmpty()) {
                hitJson.add("highlight", gson.toJsonTree(searchHit.highlight));
            }
            if (searchHit._id != null) {
                hitJson.addProperty("_id", searchHit._id);
            }
            hitJson.addProperty("_index", searchHit._index);
            hitJson.addProperty("_score", (Number)Float.valueOf(searchHit._score));
            LuceneResponseWrapper.buildSource(hitJson, searchHit._source);
            if (searchHit.inner_hits != null && !searchHit.inner_hits.isEmpty()) {
                LuceneResponseWrapper.buildInnerHits(searchHit.inner_hits, hitJson);
            }
            hitJson.addProperty("_type", searchHit._type);
            hitsArray.add((JsonElement)hitJson);
        }
        rootJson.add("hits", (JsonElement)hitsArray);
        if (!isPagesSettingsController) {
            if (totalHits != null) {
                JsonObject totalJson = new JsonObject();
                totalJson.addProperty("value", (Number)totalHits.value);
                totalJson.addProperty("relation", totalHits.relation.name());
                rootJson.add("total", (JsonElement)totalJson);
            }
            JsonObject pagesRootJson = new JsonObject();
            pagesRootJson.add("hits", (JsonElement)rootJson);
            return pagesRootJson;
        }
        return rootJson;
    }

    private static void buildInnerHits(Map<String, InnerHitsList> hitInnerHitsMap, JsonObject hitJson) {
        JsonObject innerHitsJson = new JsonObject();
        for (Map.Entry<String, InnerHitsList> entry : hitInnerHitsMap.entrySet()) {
            JsonObject innerHitsKey = new JsonObject();
            InnerHitsList innerHitsList = entry.getValue();
            innerHitsKey.addProperty("total", (Number)innerHitsList.total);
            JsonObject hitsJson = new JsonObject();
            JsonArray hitsArrayJson = new JsonArray();
            for (InnerHit innerHit : innerHitsList.hits) {
                JsonObject innerHitJsonObject = new JsonObject();
                innerHitJsonObject.addProperty("_id", innerHit._id);
                innerHitJsonObject.addProperty("_index", innerHit._index);
                innerHitJsonObject.addProperty("_score", (Number)Float.valueOf(innerHit._score));
                LuceneResponseWrapper.buildSource(innerHitJsonObject, innerHit._source);
                innerHitJsonObject.addProperty("_type", innerHit._type);
                hitsArrayJson.add((JsonElement)innerHitJsonObject);
            }
            hitsJson.add("hits", (JsonElement)hitsArrayJson);
            innerHitsKey.add("hits", (JsonElement)hitsJson);
            innerHitsJson.add(entry.getKey(), (JsonElement)innerHitsKey);
        }
        hitJson.add("inner_hits", (JsonElement)innerHitsJson);
    }

    private static JsonObject buildAggregations(LinkedHashMap<String, Aggregation> aggregations) {
        JsonObject aggregationsJson = new JsonObject();
        for (Map.Entry<String, Aggregation> aggregation : aggregations.entrySet()) {
            JsonObject aggregationJson = new JsonObject();
            Aggregation agg = aggregation.getValue();
            LuceneResponseWrapper.buildAggregationBuckets(aggregationJson, agg);
            aggregationsJson.add(aggregation.getKey(), (JsonElement)aggregationJson);
        }
        return aggregationsJson;
    }

    private static void buildAggregationBuckets(JsonObject aggregationJson, Aggregation aggregation) {
        JsonObject aggJson = new JsonObject();
        JsonArray bucketsJsonArray = new JsonArray();
        for (LabelAndValue lav : aggregation.labelsAndValues) {
            if ("__DKU__NULL__VALUE__".equals(lav.label)) continue;
            JsonObject bucketJson = new JsonObject();
            if (aggregation.isBooleanType) {
                bucketJson.addProperty("key", (Number)("true".equals(lav.label) ? 1 : 0));
                bucketJson.addProperty("key_as_string", lav.label);
            } else {
                bucketJson.addProperty("key", lav.label);
            }
            bucketJson.addProperty("doc_count", lav.value);
            bucketsJsonArray.add((JsonElement)bucketJson);
        }
        aggJson.add("buckets", (JsonElement)bucketsJsonArray);
        aggregationJson.add("agg", (JsonElement)aggJson);
        aggregationJson.addProperty("doc_count", (Number)aggregation.docCount);
    }

    private static void buildSource(JsonObject hitJson, Map<String, Object> source) {
        JsonElement sourceJson = gson.toJsonTree(source);
        hitJson.add("_source", sourceJson);
    }

    public static class Hit
    extends HitCommon {
        public Map<String, InnerHitsList> inner_hits;
        public Map<String, List<String>> highlight = new HashMap<String, List<String>>();

        public Hit(String index) {
            this._index = index;
        }

        public String toString() {
            return "Hit{_index='" + this._index + "', _type='" + this._type + "', _score=" + this._score + ", _source=" + String.valueOf(this._source) + "}";
        }
    }

    public static class InnerHitsList {
        public List<InnerHit> hits = new ArrayList<InnerHit>();
        public Integer total = 0;
    }

    public static class InnerHit
    extends HitCommon {
    }

    public static class Aggregation {
        public List<LabelAndValue> labelsAndValues;
        public long docCount;
        public boolean isBooleanType = false;

        public Aggregation(List<LabelAndValue> labelsAndValues, long docCount) {
            this.labelsAndValues = labelsAndValues;
            this.docCount = docCount;
        }

        public Aggregation(List<LabelAndValue> labelsAndValues, long docCount, boolean isBooleanType) {
            this.labelsAndValues = labelsAndValues;
            this.docCount = docCount;
            this.isBooleanType = isBooleanType;
        }

        public String toString() {
            return "Aggregation{labelsAndValues=" + String.valueOf(this.labelsAndValues) + ", isBooleanType=" + this.isBooleanType + ", docCount=" + this.docCount + "}";
        }
    }

    static abstract class HitCommon {
        public String _index;
        public String _id;
        public Map<String, Object> _source = new HashMap<String, Object>();
        public float _score = 0.0f;
        public String _type;

        HitCommon() {
        }
    }
}

