/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.staticdata;

import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.staticdata.AbstractStaticData;
import com.google.refine.grel.Control;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractExpressionSyntax
implements AbstractStaticData {
    protected final TranslationService translationService;
    protected final String lang;

    protected AbstractExpressionSyntax(TranslationService translationService, String lang) {
        this.translationService = translationService;
        this.lang = lang;
    }

    public List<GRELFunctionDef> getSyntaxFromRegistry(ControlFunctionRegistry registry, @Nullable String lang) {
        ArrayList<GRELFunctionDef> ret = new ArrayList<GRELFunctionDef>();
        registry.getFunctionMapping().forEach(e -> this.addDefinition(ret, (String)e.getKey(), ((Function)e.getValue()).getDocumentation(), lang));
        registry.getControlMapping().forEach(e -> this.addDefinition(ret, (String)e.getKey(), ((Control)e.getValue()).getDocumentation(), lang));
        ret.sort(Comparator.comparing(o -> o.name));
        return ret;
    }

    private void addDefinition(List<GRELFunctionDef> list, String functionName, Documentation doc, String lang) {
        GRELFunctionDef def = new GRELFunctionDef();
        def.name = functionName;
        String string = doc == null || StringUtils.isBlank((String)doc.category) ? this.translate(lang, "GREL.FUNCTIONS.CATEGORY.OTHER", "Other functions") : (def.category = doc.categoryTranslationId != null ? this.translate(lang, doc.categoryTranslationId, doc.category) : doc.category);
        def.description = doc == null || StringUtils.isBlank((String)doc.description) ? this.translate(lang, "GREL.FUNCTIONS.DOCUMENTATION.NO_DESCRIPTION", "No description") : (doc.descriptionTranslationId != null ? this.translate(lang, doc.descriptionTranslationId, doc.description) : doc.description);
        String string2 = def.params = doc == null || StringUtils.isBlank((String)doc.params) ? "" : doc.params;
        def.returns = doc == null || StringUtils.isBlank((String)doc.returns) ? "" : (doc.returnsTranslationId != null ? this.translate(lang, doc.returnsTranslationId, doc.returns) : doc.returns);
        List<Object> list2 = def.examples = doc == null || doc.examples == null ? new ArrayList() : doc.examples;
        if (doc != null && doc.deprecated) {
            def.deprecated = true;
            def.deprecationNotice = doc.deprecationNoticeTranslationId != null ? this.translate(lang, doc.deprecationNoticeTranslationId, doc.deprecationNotice) : doc.deprecationNotice;
        }
        def.hidden = doc != null && doc.hidden;
        list.add(def);
    }

    private String translate(String lang, String id, String defaultValue) {
        return this.translationService.translate(lang, id, defaultValue, new Object[0]);
    }

    public static class GRELFunctionDef {
        String name;
        String description;
        List<Example> examples;
        String params;
        String returns;
        String category;
        boolean hidden;
        boolean deprecated;
        String deprecationNotice;
    }
}

