/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker;

import com.dataiku.dss.shadelib.org.joda.time.Chronology;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadWritableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.chrono.ISOChronology;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParser;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParserBucket;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Locale;

public class DateTimeFormatterFix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DateTimeFormatter dateTimeFormatter;
    private final boolean offsetParsed;
    private final Locale locale;
    private final Integer pivotYear;
    private final Chronology chrono;
    private final DateTimeZone zone;
    private final DateTimeParser parser;

    public static DateTimeFormatterFix forPattern(String pattern) {
        return new DateTimeFormatterFix(DateTimeFormat.forPattern((String)DateTimeFormatterFix.convertToJodaPattern(pattern)));
    }

    private DateTimeFormatterFix(DateTimeFormatter dtf) {
        Preconditions.checkNotNull((Object)dtf, (Object)"dtf cannot be null");
        this.dateTimeFormatter = dtf;
        this.parser = dtf.getParser();
        this.locale = dtf.getLocale();
        this.pivotYear = dtf.getPivotYear();
        this.chrono = dtf.getChronology();
        this.zone = dtf.getZone();
        this.offsetParsed = dtf.isOffsetParsed();
    }

    public String print(ReadableInstant instant) {
        return this.dateTimeFormatter.print(instant);
    }

    public int parseInto(ReadWritableInstant instant, String text, int position) {
        Preconditions.checkNotNull((Object)instant, (Object)"Instant must not be null");
        Preconditions.checkArgument((instant.getMillis() == 0L ? 1 : 0) != 0, (Object)"Instant must be initialized with the EPOCH value (0)");
        Chronology chrono = instant.getChronology();
        if (chrono == null) {
            chrono = ISOChronology.getInstance();
        }
        long instantMillis = instant.getMillis();
        int defaultYear = chrono.year().get(instantMillis);
        long instantLocal = instantMillis + (long)chrono.getZone().getOffset(instantMillis);
        if (this.chrono != null) {
            chrono = this.chrono;
        }
        if (this.zone != null) {
            chrono = chrono.withZone(this.zone);
        }
        DateTimeParserBucket bucket = new DateTimeParserBucket(instantLocal, chrono, this.locale, this.pivotYear, defaultYear);
        int newPos = this.parser.parseInto(bucket, text, position);
        long millis = bucket.computeMillis(true, text);
        instant.setMillis(millis);
        if (this.offsetParsed && bucket.getOffsetInteger() != null) {
            int parsedOffset = bucket.getOffsetInteger();
            DateTimeZone parsedZone = DateTimeZone.forOffsetMillis((int)parsedOffset);
            chrono = chrono.withZone(parsedZone);
        } else if (bucket.getZone() != null) {
            chrono = chrono.withZone(bucket.getZone());
        }
        instant.setChronology(chrono);
        if (this.zone != null) {
            instant.setZone(this.zone);
        }
        return newPos;
    }

    public DateTimeZone getZone() {
        return this.zone;
    }

    public DateTimeFormatterFix withZone(DateTimeZone zone) {
        if (this.zone == zone) {
            return this;
        }
        return new DateTimeFormatterFix(this.dateTimeFormatter.withZone(zone));
    }

    public DateTimeFormatterFix withLocale(Locale locale) {
        return new DateTimeFormatterFix(this.dateTimeFormatter.withLocale(locale));
    }

    public String toString() {
        return this.dateTimeFormatter.toString();
    }

    @VisibleForTesting
    static String convertToJodaPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean quoted = false;
        int length = pattern.length();
        for (int i = 0; i < length; ++i) {
            char c2 = pattern.charAt(i);
            if (c2 == '\'') {
                if (!quoted) {
                    quoted = true;
                } else if (i < length - 1 && pattern.charAt(i + 1) == '\'') {
                    result.append(c2);
                    ++i;
                } else {
                    quoted = false;
                }
            } else if (!quoted) {
                if (c2 == 'Y') {
                    c2 = 'x';
                } else if (c2 == 'u') {
                    c2 = 'e';
                }
            }
            result.append(c2);
        }
        return result.toString();
    }
}

