/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.shaker.filter.DisplayFilterColumn;
import java.util.HashSet;
import java.util.Set;

public class NumericAsAlphanumericValueFilter
extends DisplayFilterColumn {
    private boolean exclude;
    private Set<String> facetValues = new HashSet<String>();
    private boolean dkuNoValue;

    public NumericAsAlphanumericValueFilter(String column, String[] facetValues, boolean exclude) {
        this.column = column;
        for (String v : facetValues) {
            this.facetValues.add(v);
            if (!v.equals("") && !v.equals("___dku_no_value___")) continue;
            this.dkuNoValue = true;
        }
        this.exclude = exclude;
    }

    @Override
    protected boolean filterRow(MemRow row, Column cd) {
        String value = row.get(cd);
        if (value == null || value.isEmpty()) {
            return this.updateFilteredRegister(this.dkuNoValue);
        }
        double numValue = Double.parseDouble(value);
        String formattedValue = (double)((long)numValue) == numValue ? String.format("%d", (long)numValue) : Double.toString(numValue);
        boolean matches = this.facetValues.contains(formattedValue);
        return this.updateFilteredRegister(matches);
    }

    private boolean updateFilteredRegister(boolean matches) {
        if (this.exclude && matches) {
            return false;
        }
        return this.exclude || matches;
    }
}

