/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.model;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ScriptStepDeserializer;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.OverrideTable;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.Serializable;
import org.apache.log4j.Logger;

@UIModel
public abstract class ScriptStep
implements Serializable {
    private static final long serialVersionUID = -1L;
    public MetaType metaType = MetaType.PROCESSOR;
    public boolean preview;
    public boolean disabled;
    public String name;
    public String comment;
    public boolean alwaysShowComment;
    public String mainColor;
    public String secondaryColor;
    public OverrideTable overrideTable;
    public ProcessorWithRecordedReport.ProcessorRecordedReport designTimeReport;
    private static Logger logger;

    public static void loadClass() {
        BaseProcessorsFactory.loadClass();
    }

    public ScriptStep expand(VariablesContext vc, int i) {
        if (this.overrideTable != null) {
            logger.info((Object)("Applying override on step  " + i));
            ScriptStep newStep = this.overrideTable.overrideObject(vc, this, ScriptStep.class);
            return newStep;
        }
        return this;
    }

    static {
        JSON.registerAdapter(ScriptStep.class, (Object)((Object)ScriptStepDeserializer.INSTANCE));
        logger = Logger.getLogger((String)"dku.scriptstep");
    }

    public static enum MetaType {
        PROCESSOR,
        GROUP;

    }

    public static enum StepCodes implements InfoMessage.MessageCode
    {
        WARN_SCRIPTSTEP_UNKNOWN_INPUT_COLUMN("Unknown input column", InfoMessage.FixabilityCategory.USER_CONFIG),
        WARN_SCRIPTSTEP_DISABLED_BY_ADMIN("Usage of processor disabled by admin", InfoMessage.FixabilityCategory.USER_CONFIG),
        WARN_DELETED_COLUMN_MAY_BE_USED("Pattern/All columns used after delete or rename step", InfoMessage.FixabilityCategory.USER_CONFIG);

        private final InfoMessage.FixabilityCategory fixability;
        private final String title;

        private StepCodes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

