/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.plugins.HadoopJavaPluginsHelper;
import com.dataiku.dip.plugins.HadoopJythonPluginsHelper;
import com.dataiku.dip.plugins.HadoopPluginSettingsHelper;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.mrimpl.DiagnosticsHandler;
import com.dataiku.dip.shaker.mrimpl.ShakerJobConfigurator;
import com.dataiku.dip.shaker.mrimpl.ShakerScriptMapper;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.formats.UniversalFileInputFormat;
import com.dataiku.dip.shaker.mrimpl.formats.UniversalFileOutputFormat;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.util.HadoopUtils;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ShakerMRJobRunner {
    private static final Logger logger = Logger.getLogger((String)"dku.mr");
    private final List<Path> inputPaths;
    private final Path outputPath;
    private final SerializedShakerScript shakerScript;
    private final Dataset inputDataset;
    private final Dataset outputDataset;
    private final HashMap<String, String> resourceMapping;
    private final AuthCtx authCtx;
    private final List<SimpleKeyValue> configKeys;
    private final String recipeProjectKey;
    private String[] arguments;
    private volatile boolean abortNotified;
    private Job job;
    @Autowired
    private ImpersonationResolverService impersonationService;

    public ShakerMRJobRunner(AuthCtx authCtx, Dataset mainInputDataset, Dataset outputDataset, SerializedShakerScript shakerScript, List<Path> mainInputPaths, Path outputPath, List<File> resourceFiles, List<File> jarFiles, HashMap<String, String> resourceMapping, List<SimpleKeyValue> configKeys, String recipeProjectKey) {
        File shims;
        SpringUtils.getInstance().autowire((Object)this);
        this.inputPaths = mainInputPaths;
        this.outputPath = outputPath;
        this.shakerScript = shakerScript;
        this.inputDataset = mainInputDataset;
        this.outputDataset = outputDataset;
        this.resourceMapping = resourceMapping;
        this.configKeys = configKeys;
        this.authCtx = authCtx;
        this.recipeProjectKey = recipeProjectKey;
        ArrayList<File> libDirs = new ArrayList<File>();
        libDirs.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/ivy/common-run"));
        libDirs.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/ivy/backend-run"));
        libDirs.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib"));
        libDirs.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/third"));
        IPluginsRegistryService ps2 = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        for (InstalledPluginDesc installedPluginDesc : ps2.getLoadedPlugins()) {
            String pluginId = installedPluginDesc.desc.id;
            File libDir = new File(System.getenv("DIP_HOME") + "/plugins/installed/" + pluginId + "/lib");
            if (!libDir.isDirectory()) continue;
            logger.info((Object)("Adding a libdir " + String.valueOf(libDir)));
            libDirs.add(libDir);
        }
        ArrayList<Object> jarPaths = new ArrayList<Object>();
        jarPaths.add(new File(ApplicationConfigurator.getInstallFolder() + "/dist/dataiku-core.jar").getAbsolutePath());
        jarPaths.add(new File(ApplicationConfigurator.getInstallFolder() + "/dist/dataiku-hproxy-client.jar").getAbsolutePath());
        jarPaths.add(new File(ApplicationConfigurator.getInstallFolder() + "/dist/dataiku-app-platform.jar").getAbsolutePath());
        jarPaths.add(new File(ApplicationConfigurator.getInstallFolder() + "/dist/dataiku-prepare-core.jar").getAbsolutePath());
        jarPaths.add(new File(ApplicationConfigurator.getInstallFolder() + "/dist/dataiku-dss-core.jar").getAbsolutePath());
        for (File libDir : libDirs) {
            logger.info((Object)("Look for jars in " + String.valueOf(libDir)));
            for (File libJar : libDir.listFiles()) {
                jarPaths.add(libJar.getAbsolutePath());
            }
        }
        for (File jar : jarFiles) {
            jarPaths.add(jar.getAbsolutePath());
        }
        String string = System.getenv("DKU_HIVE_CP");
        if (!StringUtils.isBlank((String)string)) {
            String[] files = DKUtils.parseClassPath((String)string);
            for (String path : files) {
                File file = new File(path);
                if (!file.exists() || file.isDirectory()) continue;
                jarPaths.add(path);
            }
        }
        if (HadoopFlavorUtils.isHive3() && (shims = new File(ApplicationConfigurator.getInstallFolder() + "/lib/shims/hive3-shims.jar")).exists() && shims.isFile()) {
            jarPaths.add(shims.getAbsolutePath());
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        for (File resource : resourceFiles) {
            if (resource.isDirectory()) {
                logger.info((Object)("Distribute folder " + String.valueOf(resource)));
                for (File subfile : resource.listFiles()) {
                    logger.info((Object)("  Distribute subfile " + subfile.getAbsolutePath()));
                    filePaths.add(subfile.getAbsolutePath());
                }
                continue;
            }
            logger.info((Object)("Distribute file " + resource.getAbsolutePath()));
            filePaths.add(resource.getAbsolutePath());
        }
        this.arguments = new String[]{"-libjars", StringUtils.join(jarPaths, (String)",")};
        if (filePaths.size() > 0) {
            this.arguments = (String[])ArrayUtils.add((Object[])this.arguments, (Object)"-files");
            this.arguments = (String[])ArrayUtils.add((Object[])this.arguments, (Object)StringUtils.join(filePaths, (String)","));
        }
        System.out.println("*************** START CONFIG ************");
        System.out.println(configKeys.size());
    }

    public UserGroupInformation makeUGI() throws DKUSecurityException, IOException {
        UserGroupInformation ret = null;
        if (this.impersonationService.isEnabled()) {
            String hadoopUserToImpersonate = this.impersonationService.getTargetUser((String)this.outputDataset.getProjectKey(), (AuthCtx)this.authCtx).hadoopUser;
            ret = UserGroupInformation.createProxyUser((String)hadoopUserToImpersonate, (UserGroupInformation)UserGroupInformation.getLoginUser());
        } else {
            ret = UserGroupInformation.getCurrentUser();
        }
        logger.info((Object)("Built Hadoop UGI for " + this.outputDataset.getProjectKey() + ": " + String.valueOf(ret)));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Object sk2;
        logger.info((Object)("Starting Hadoop job with args : " + StringUtils.join((Object[])this.arguments)));
        final Configuration configuration = new Configuration();
        for (Object sk2 : this.configKeys) {
            System.out.println("SK Key " + sk2.key + " VAL " + sk2.value);
            configuration.set(sk2.key, sk2.value);
        }
        this.addConfigKeysForDataset(configuration, this.inputDataset);
        this.addConfigKeysForDataset(configuration, this.outputDataset);
        GenericOptionsParser parser = null;
        sk2 = ShakerMRJobRunner.class;
        synchronized (ShakerMRJobRunner.class) {
            parser = new GenericOptionsParser(configuration, this.arguments);
            // ** MonitorExit[sk /* !! */ ] (shouldn't be in output)
            final GenericOptionsParser fparser = parser;
            HadoopUtils.fixedUpDoAs(this.makeUGI(), new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    MyApp tool = new MyApp();
                    tool.setConf(configuration);
                    tool.run(fparser.getRemainingArgs());
                    return null;
                }
            });
            return;
        }
    }

    private void addConfigKeysForDataset(Configuration conf, Dataset dataset) throws IOException {
        try (DatasetHandler handler = DatasetHandlerFactory.build(this.authCtx, dataset);){
            if (handler instanceof HDFSDatasetHandler) {
                ((HDFSDatasetHandler)handler).addExtraConf(conf, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAbort() {
        Job jobCopy;
        ShakerMRJobRunner shakerMRJobRunner = this;
        synchronized (shakerMRJobRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            jobCopy = this.job;
        }
        if (jobCopy != null) {
            try {
                logger.info((Object)"Killing MR job");
                jobCopy.killJob();
            }
            catch (IOException e) {
                logger.error((Object)"Unable to kill job");
            }
        } else {
            logger.info((Object)"MR job not started, nothing to abort");
        }
    }

    public class MyApp
    extends Configured
    implements Tool {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int run(String[] args) throws Exception {
            ShakerMRJobRunner shakerMRJobRunner = ShakerMRJobRunner.this;
            synchronized (shakerMRJobRunner) {
                if (ShakerMRJobRunner.this.abortNotified) {
                    logger.error((Object)"Activity aborted, do not start MR job");
                    return 1;
                }
                ShakerMRJobRunner.this.job = Job.getInstance((Configuration)this.getConf());
                Configuration conf = ShakerMRJobRunner.this.job.getConfiguration();
                ShakerJobConfigurator.setJobScript(conf, ShakerMRJobRunner.this.shakerScript);
                ShakerJobConfigurator.setJobResourceMapping(conf, new ShakerJobConfigurator.ResourceMapping(ShakerMRJobRunner.this.resourceMapping));
                HadoopJavaPluginsHelper.PluginsWithJavaState pwjs = HadoopJavaPluginsHelper.buildState();
                HadoopJythonPluginsHelper.PluginsWithJythonState pwjys = HadoopJythonPluginsHelper.buildState();
                HadoopPluginSettingsHelper.PluginsSettingsState pss = HadoopPluginSettingsHelper.buildState(ShakerMRJobRunner.this.recipeProjectKey);
                ShakerJobConfigurator.setPluginsState(conf, pwjs);
                ShakerJobConfigurator.setPluginStepsState(conf, pwjys);
                ShakerJobConfigurator.setPluginSettingsState(conf, pss);
                DatasetConfig outputDatasetConfig = new DatasetConfig(ShakerMRJobRunner.this.outputDataset.serialize());
                UniversalFileOutputFormat.setOutputDatasetConfig(conf, outputDatasetConfig);
                UniversalFileOutputFormat.setOutputPath((Job)ShakerMRJobRunner.this.job, (Path)ShakerMRJobRunner.this.outputPath);
                DatasetConfig inputDatasetConfig = new DatasetConfig(ShakerMRJobRunner.this.inputDataset.serialize());
                UniversalFileInputFormat.setInputDatasetConfig(conf, inputDatasetConfig);
                for (Path ip : ShakerMRJobRunner.this.inputPaths) {
                    UniversalFileInputFormat.addInputPath((Job)ShakerMRJobRunner.this.job, (Path)ip);
                }
                DiagnosticsHandler.setWarningsContextDirectory(conf, ShakerMRJobRunner.this.outputPath);
                ShakerMRJobRunner.this.job.setJarByClass(ShakerScriptMapper.class);
                ShakerMRJobRunner.this.job.setOutputKeyClass(Void.class);
                ShakerMRJobRunner.this.job.setOutputValueClass(RowWithFactories.class);
                ShakerMRJobRunner.this.job.setInputFormatClass(UniversalFileInputFormat.class);
                ShakerMRJobRunner.this.job.setOutputFormatClass(UniversalFileOutputFormat.class);
                ShakerMRJobRunner.this.job.setMapperClass(ShakerScriptMapper.class);
                ShakerMRJobRunner.this.job.setNumReduceTasks(0);
                logger.info((Object)("Dumping configuration:\n" + conf.toString()));
                ShakerMRJobRunner.this.job.submit();
                logger.info((Object)("Job URL : " + ShakerMRJobRunner.this.job.getTrackingURL()));
            }
            if (!ShakerMRJobRunner.this.job.waitForCompletion(true)) {
                throw new IOException("Hadoop job failed");
            }
            return 0;
        }
    }
}

