/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform.interactivedatapreparation;

import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.InteractiveExtractor;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.TokenPattern;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.SimpleToken;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.token.Token;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtractingPattern {
    final TokenPattern beforeTokens;
    final TokenPattern selectionTokens;
    final TokenPattern afterTokens;
    transient Pattern compiledPattern = null;
    final boolean isRawCompiled;
    final int score;
    static final int CUSTOM_REGEX_COMPLEXITY = 4;
    static final List<String> CUSTOM_RAW_REGEX = Lists.newArrayList((Object[])new String[]{"(#\\w+)", "#(\\w+)", "(@\\w+)", "@(\\w+)", "(https?://\\S+)", "https?://(\\S+)", "((?:[0-9]{1,3}\\.){3}[0-9]{1,3})", "((?:[A-F0-9]{1,4}:){7}[A-F0-9]{1,4})", "([0-9]{4}\\pP[0-9]{2}\\pP[0-9]{2})", "([0-9]{2}\\pP[0-9]{2}\\pP[0-9]{4})", "([0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}Z?)", "([0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[\\-\\+][0-9]{2}:[0-9]{2})", "([-+]?(?:[0-9]+(?:,[0-9]+)?))", "([-+]?(?:[0-9]+(?:\\.[0-9]*)?|\\.[0-9]+))", "([-+]?(?:[0-9]+(?: [0-9]{3})*(?:\\.[0-9]*)?))", "([-+]?(?:[0-9]+(?: [0-9]{3})*(?:,[0-9]*)?))", "([-+]?(?:[0-9]+(?: [0-9]{3})*(?:\\.[0-9]*)?))", "([-+]?(?:[0-9]+(?:\\.[0-9]{3})*(?:,[0-9]*)?))", "([-+]?(?:[0-9]+(?:,[0-9]{3})*(?:\\.[0-9]*)?))", "([-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)", "([-+]?(?:[0-9]+(?:(?:\\pP| )[0-9]{3})*(?:(?:,|\\.)[0-9]+)?))", "(\\+(?:[0-9] ?){6,14}[0-9])", "((?:\\+1)?[- ]?\\(?[0-9]{3}\\)?[-. ]?[0-9]{3}[-. ]?[0-9]{4})", "((?:\\+33|0) ?[0-9](?:[-. ]?[0-9]{2}){4})", "([+-]?(?:[0-9]+))", "((?<![0-9.+-])(?>[+-]?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))))", "((?<![0-9A-Fa-f])(?:[+-]?(?:0x)?(?:[0-9A-Fa-f]+)))", "\\b((?<![0-9A-Fa-f.])(?:[+-]?(?:0x)?(?:(?:[0-9A-Fa-f]+(?:\\.[0-9A-Fa-f]*)?)|(?:\\.[0-9A-Fa-f]+))))\\b", "((?>(?<!\\\\)(?>\"(?>\\\\.|[^\\\\\"]+)+\"|\"\"|(?>'(?>\\\\.|[^\\\\']+)+')|''|(?>`(?>\\\\.|[^\\\\`]+)+`)|``)))", "([A-Fa-f0-9]{8}-(?:[A-Fa-f0-9]{4}-){3}[A-Fa-f0-9]{12})", "((?:urn|URN):[0-9A-Za-z][0-9A-Za-z-]{0,31}:(?:%[0-9a-fA-F]{2}|[0-9A-Za-z()+,.:=@;$_!*'/?#-])+)", "(?:urn|URN):([0-9A-Za-z][0-9A-Za-z-]{0,31}:(?:%[0-9a-fA-F]{2}|[0-9A-Za-z()+,.:=@;$_!*'/?#-])+)", "((?:[A-Fa-f0-9]{4}\\.){2}[A-Fa-f0-9]{4})", "((?:[A-Fa-f0-9]{2}-){5}[A-Fa-f0-9]{2})", "((?:[A-Fa-f0-9]{2}:){5}[A-Fa-f0-9]{2})", "((?:[A-F0-9]{1,4}:){7}[A-F0-9]{1,4})", "((?<![0-9])(?:(?:[0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])[.](?:[0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])[.](?:[0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])[.](?:[0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5]))(?![0-9]))", "(\\b(?:[0-9A-Za-z][0-9A-Za-z-]{0,62})(?:\\.(?:[0-9A-Za-z][0-9A-Za-z-]{0,62}))*(?:.?|\\b))", "((?:\\/[\\w_%!$@:.,+~-]*)+)", "((?>[A-Za-z]+:|\\\\)(?:\\\\[^\\\\?*]*)+)", "(\\b(?:[Jj]an(?:uary|uar)?|[Ff]eb(?:ruary|ruar)?|[Mm](?:a|\u00e4)?r(?:ch|z)?|[Aa]pr(?:il)?|[Mm]a(?:y|i)?|[Jj]un(?:e|i)?|[Jj]ul(?:y|i)?|[Aa]ug(?:ust)?|[Ss]ep(?:tember)?|[Oo](?:c|k)?t(?:ober)?|[Nn]ov(?:ember)?|[Dd]e(?:c|z)(?:ember)?)\\b)", "((?:Mon(?:day)?|Tue(?:sday)?|Wed(?:nesday)?|Thu(?:rsday)?|Fri(?:day)?|Sat(?:urday)?|Sun(?:day)?))", "([Aa]lert|ALERT|[Tt]race|TRACE|[Dd]ebug|DEBUG|[Nn]otice|NOTICE|[Ii]nfo?(?:rmation)?|INFO?(?:RMATION)?|[Ww]arn?(?:ing)?|WARN?(?:ING)?|[Ee]rr?(?:or)?|ERR?(?:OR)?|[Cc]rit?(?:ical)?|CRIT?(?:ICAL)?|[Ff]atal|FATAL|[Ss]evere|SEVERE|EMERG(?:ENCY)?|[Ee]merg(?:ency)?)"});

    public ExtractingPattern(TokenPattern beforeTokens, TokenPattern selectionTokens, TokenPattern afterTokens) {
        this.beforeTokens = beforeTokens;
        this.selectionTokens = selectionTokens;
        this.afterTokens = afterTokens;
        this.score = this.getComplexityScore();
        this.isRawCompiled = false;
    }

    public ExtractingPattern(String regex) {
        this.beforeTokens = new TokenPattern(new SimpleToken(regex, 4));
        this.selectionTokens = new TokenPattern();
        this.afterTokens = new TokenPattern();
        this.score = 4;
        this.isRawCompiled = true;
    }

    static List<ExtractingPattern> getCustomPatterns() {
        ArrayList<ExtractingPattern> customPatterns = new ArrayList<ExtractingPattern>();
        for (String regex : CUSTOM_RAW_REGEX) {
            customPatterns.add(new ExtractingPattern(regex));
        }
        return customPatterns;
    }

    static String trimRegex(StringBuilder strBldRegex) {
        if (strBldRegex.length() < 2) {
            return strBldRegex.toString();
        }
        if (strBldRegex.substring(0, 3).equals(".*?")) {
            strBldRegex.delete(0, 3);
        }
        if (strBldRegex.substring(0, 2).equals(".*")) {
            strBldRegex.delete(0, 2);
        }
        if (strBldRegex.substring(strBldRegex.length() - 2, strBldRegex.length()).equals(".*")) {
            strBldRegex.delete(strBldRegex.length() - 2, strBldRegex.length());
        }
        return strBldRegex.toString();
    }

    String toRegex() {
        StringBuilder strBld = new StringBuilder();
        for (Token token : this.beforeTokens.tokens) {
            strBld.append(token.toRegex());
        }
        if (this.selectionTokens.tokens.size() > 0) {
            strBld.append("(");
            for (Token token : this.selectionTokens.tokens) {
                strBld.append(token.toRegex());
            }
            strBld.append(")");
        }
        for (Token token : this.afterTokens.tokens) {
            strBld.append(token.toRegex());
        }
        if (this.isRawCompiled) {
            return strBld.toString();
        }
        return ExtractingPattern.trimRegex(strBld);
    }

    private int getComplexityScore() {
        return this.beforeTokens.getComplexity() + this.selectionTokens.getComplexity() + this.afterTokens.getComplexity();
    }

    List<InteractiveExtractor.ExtractionPosition> extract(String sentence) {
        if (this.compiledPattern == null) {
            this.compiledPattern = Pattern.compile(this.toRegex());
        }
        Matcher matcher = this.compiledPattern.matcher(sentence);
        ArrayList<InteractiveExtractor.ExtractionPosition> matches = new ArrayList<InteractiveExtractor.ExtractionPosition>();
        while (matcher.find() && matcher.groupCount() > 0) {
            matches.add(new InteractiveExtractor.ExtractionPosition(matcher.start(1), matcher.end(1)));
        }
        return matches;
    }
}

