/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.io.AbstractImpersonableSecretProtectedPythonKernel;
import com.dataiku.dip.shaker.processors.udf.CustomJythonStepParams;
import com.dataiku.dip.shaker.processors.udf.JythonUDFUtils;
import com.dataiku.dip.shaker.processors.udf.LoadedJythonProcessor;
import com.dataiku.dip.shaker.processors.udf.PythonParameter;
import com.dataiku.dip.shaker.processors.udf.PythonUDFModeHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.python.core.PyException;
import org.python.core.PyObject;

public class PythonUDFCell
implements PythonUDFModeHandler {
    public final String columnName;
    public final String errorColumnName;
    public Column column;
    public Column errorColumn;

    public PythonUDFCell(PythonParameter parameter) {
        this.columnName = parameter.column;
        this.errorColumnName = parameter.errorColumn;
    }

    public PythonUDFCell(LoadedJythonProcessor loaded, CustomJythonStepParams params) {
        this.columnName = params.outputColumn;
        this.errorColumnName = params.errorColumn;
    }

    @Override
    public void emitFromJython(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, Row row, PyObject result) throws Exception {
        row.put(this.column, JythonUDFUtils.formatObjet(result));
        processorOutput.emitRow(row);
    }

    @Override
    public void errorFromJython(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, Row row, PyException e) throws Exception {
        String error = JythonUDFUtils.formatPyException(e);
        row.put(this.errorColumn, error);
        processorOutput.emitRow(row);
    }

    @Override
    public void emitFromKernel(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, Row row, Object result) throws Exception {
        String objStr = JythonUDFUtils.objToStr(result);
        row.put(this.column, objStr);
        processorOutput.emitRow(row);
    }

    @Override
    public void emitVectorFromKernel(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, List<Row> rows, List<Integer> indices, Object result) throws Exception {
        List<Object> results;
        if (indices.size() != rows.size()) {
            throw new Exception("Vectorized udf did not return vector of same length (" + indices.size() + " , expected " + rows.size() + ")");
        }
        if (result == null) {
            result = new ArrayList(rows.size());
        }
        if ((results = JythonUDFUtils.unvectorizeToList(result)).size() != rows.size()) {
            throw new Exception("Vectorized function changed the vector size");
        }
        for (int i = 0; i < rows.size(); ++i) {
            this.emitFromKernel(processorOutput, cf, rf, rows.get(i), results.get(i));
        }
    }

    @Override
    public void errorFromKernel(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, Row row, AbstractImpersonableSecretProtectedPythonKernel.PythonError e) throws Exception {
        String error = e.getSerializedThrowable().getMessage();
        row.put(this.errorColumn, error);
        processorOutput.emitRow(row);
    }

    @Override
    public void errorVectorFromKernel(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, List<Row> rows, AbstractImpersonableSecretProtectedPythonKernel.PythonError e) throws Exception {
        for (Row row : rows) {
            this.errorFromKernel(processorOutput, cf, rf, row, e);
        }
    }

    @Override
    public void initModeSpecific(ColumnFactory cf) throws Exception {
        this.column = cf.column(this.columnName, Processor.ProcessorRole.OUTPUT_COLUMN);
        this.errorColumn = cf.column(StringUtils.isBlank((String)this.errorColumnName) ? this.columnName : this.errorColumnName, Processor.ProcessorRole.OUTPUT_COLUMN);
    }
}

