/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sampleio;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.io.BinaryStreamEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class SampleWriter
implements AutoCloseable {
    private BinaryStreamEncoder binaryEncoder;
    private int[] colIdx;

    public SampleWriter(File outputFile, boolean compressed) throws IOException {
        BufferedOutputStream rawOutputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        ((OutputStream)rawOutputStream).write(68);
        ((OutputStream)rawOutputStream).write(83);
        ((OutputStream)rawOutputStream).write(83);
        if (compressed) {
            ((OutputStream)rawOutputStream).write(50);
            this.binaryEncoder = new BinaryStreamEncoder(new GZIPOutputStream(rawOutputStream));
        } else {
            ((OutputStream)rawOutputStream).write(49);
            this.binaryEncoder = new BinaryStreamEncoder(rawOutputStream);
        }
    }

    public SampleWriter(File outputFile) throws IOException {
        this(outputFile, false);
    }

    public void writeMemTable(MemTable memTable) throws IOException {
        this.writeHeader(memTable);
        for (int i = 0; i < memTable.rows.size(); ++i) {
            this.writeRow(memTable.rows.get(i));
        }
    }

    @Override
    public void close() throws IOException {
        this.binaryEncoder.close();
    }

    private void writeHeader(MemTable memTable) throws IOException {
        this.binaryEncoder.writeVInt(memTable.columnsList.size());
        this.colIdx = new int[memTable.columnsList.size()];
        for (int i = 0; i < memTable.columnsList.size(); ++i) {
            this.colIdx[i] = memTable.columnsList.get((int)i).index;
            this.binaryEncoder.writeUTF8LenAndString(memTable.columnsList.get(i).getName());
        }
    }

    public ProcessorOutput writeFromProcessor(Schema schema, ColumnFactory cf) throws IOException {
        List cols = schema.getColumns();
        this.binaryEncoder.writeVInt(cols.size());
        final ArrayList<Column> columns = new ArrayList<Column>();
        for (SchemaColumn sc : cols) {
            this.binaryEncoder.writeUTF8LenAndString(sc.getName());
            columns.add(cf.column(sc.getName()));
        }
        return new SinkProcessorOutput(){
            private StringBuilder sb = new StringBuilder();

            public void emitRow(Row row) throws Exception {
                this.sb.setLength(0);
                for (Column col : columns) {
                    String val = row.get(col);
                    if (val == null || val.isEmpty()) {
                        SampleWriter.this.binaryEncoder.writeVInt(0L);
                        continue;
                    }
                    SampleWriter.this.binaryEncoder.writeVInt(val.length());
                    this.sb.append(val);
                }
                SampleWriter.this.binaryEncoder.writeUTF8LenAndString(this.sb.toString());
            }

            public void lastRowEmitted() throws Exception {
                SampleWriter.this.binaryEncoder.flush();
            }
        };
    }

    private void writeRow(MemRow memRow) throws IOException {
        int usedLength = 0;
        for (int idx : this.colIdx) {
            if (memRow.cellLengths.length <= idx) continue;
            usedLength += memRow.cellLengths[idx];
        }
        char[] reorderedBuf = new char[usedLength];
        int newOff = 0;
        for (int idx : this.colIdx) {
            if (memRow.cellLengths.length > idx) {
                int length = memRow.cellLengths[idx];
                int oldOffset = memRow.cellOffsets[idx];
                System.arraycopy(memRow.buffer, oldOffset, reorderedBuf, newOff, length);
                newOff += length;
                this.binaryEncoder.writeVInt(memRow.cellLengths[idx]);
                continue;
            }
            this.binaryEncoder.writeVInt(0L);
        }
        this.binaryEncoder.writeUTF8LenAndString(reorderedBuf);
    }
}

