/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.yarnaware;

import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.yarnaware.YarnClusterSSHTunnel;
import com.google.common.collect.Maps;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class YarnClusterSSHTunnelRegistry {
    private static Map<Key, YarnClusterSSHTunnel> tunnels = Maps.newHashMap();
    private static int localPort = -1;
    private static Logger logger = Logger.getLogger((String)"dku.spark.yarn-cluster.tunnels");

    public static void setLocalPort(int port) {
        localPort = port;
    }

    public static synchronized void give(YarnClusterSSHTunnel tunnel) {
        --tunnel.refCount;
        if (tunnel.refCount <= 0) {
            String connectionName = tunnel.getConnectionName();
            logger.info((Object)("Remove tunnel on connection " + connectionName + " for port " + localPort));
            tunnels.remove(new Key(connectionName));
            tunnel.close();
        }
    }

    public static synchronized YarnClusterSSHTunnel getOrCreate(AuthCtx authCtx, String connectionName, String bindAddress) throws IOException, DKUSecurityException, JSchException {
        if (localPort < 0) {
            throw new IllegalStateException("Port not initialized");
        }
        Key key = new Key(connectionName);
        YarnClusterSSHTunnel tunnel = tunnels.get(key);
        if (tunnel == null) {
            logger.info((Object)("Create tunnel on connection " + connectionName + " for host " + bindAddress + " port " + localPort));
            tunnel = new YarnClusterSSHTunnel(authCtx, connectionName, bindAddress, localPort);
            tunnels.put(key, tunnel);
        }
        ++tunnel.refCount;
        return tunnel;
    }

    public static synchronized YarnClusterSSHTunnel getOrCreate(AuthCtx authCtx, SSHConnection connection, String bindAddress) throws IOException, DKUSecurityException, JSchException {
        if (localPort < 0) {
            throw new IllegalStateException("Port not initialized");
        }
        Key key = new Key(connection.name);
        YarnClusterSSHTunnel tunnel = tunnels.get(key);
        if (tunnel == null) {
            logger.info((Object)("Create tunnel on connection " + connection.name + " for host " + bindAddress + " port " + localPort));
            tunnel = new YarnClusterSSHTunnel(authCtx, connection, bindAddress, localPort);
            tunnels.put(key, tunnel);
        }
        ++tunnel.refCount;
        return tunnel;
    }

    public static class Key {
        public final String connectionName;

        public Key(String host) {
            this.connectionName = host;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionName == null ? 0 : this.connectionName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return StringUtils.equals((String)this.connectionName, (String)other.connectionName);
        }
    }
}

