/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomJavaElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.sql.CustomJavaDialectDesc;
import com.dataiku.dip.sql.CustomSQLDialectsRegistry;
import com.dataiku.dip.sql.LoadedJavaDialect;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomJavaDialectsService
extends CustomJavaElementService<CustomJavaDialectDesc, LoadedJavaDialect> {
    @Override
    public String getFolderName() {
        return "java-dialects";
    }

    @Override
    public String getPrefix() {
        return "dialect";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "dialect_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomJavaDialectDesc> getDescClass() {
        return CustomJavaDialectDesc.class;
    }

    @Override
    public Class<LoadedJavaDialect> getLoadedDescClass() {
        return LoadedJavaDialect.class;
    }

    @Override
    protected void removeElement(LoadedJavaDialect desc) {
        CustomSQLDialectsRegistry.deregister(desc.getType());
    }

    @Override
    protected LoadedJavaDialect load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedJavaDialect loaded = new LoadedJavaDialect(elementType, pluginId, elementId, (CustomJavaDialectDesc)JSON.parseFile((File)file, CustomJavaDialectDesc.class));
        CustomSQLDialectsRegistry.register(loaded);
        return loaded;
    }

    @Override
    protected String getCodeExtension(LoadedJavaDialect desc) {
        return ".java";
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomJavaDialectDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                this.genericValidateMeta(desc.meta);
                if (StringUtils.isBlank((String)desc.dialectClass)) {
                    this.withFatal("Java plugin dialect require a \"dialectClass\" field.");
                }
                return this.messages;
            }
        }.validate();
    }
}

