/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetRecordCount;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SnowflakeSQLDialect
extends GenericSQLDialect {
    protected final ThreadLocal<SimpleDateFormat> dateOnlyParser = new ThreadLocal();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.dialect.snowflake");

    @Override
    protected void ensureThreadLocalsAreHere() {
        super.ensureThreadLocalsAreHere();
        if (this.dateOnlyParser.get() == null) {
            this.dateOnlyParser.set(new SimpleDateFormat("yyyy-MM-dd"));
        }
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return new DSSTypeSQLMapping(schemaColumn.getType(), -5, "bigint", new Integer[]{2, 3});
            }
            case FLOAT: 
            case DOUBLE: {
                return new DSSTypeSQLMapping(schemaColumn.getType(), 8, "double", new Integer[]{7});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 2014, "timestamptz", new Integer[]{91, 93});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93, 2014});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestampntz", new Integer[]{91, 2014});
            }
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, "varchar(" + schemaColumn.getMaxLength() + ")", new Integer[]{2003, 1, 1111, -16, -1, -9});
            }
            case GEOMETRY: 
            case GEOPOINT: {
                return new DSSTypeSQLMapping(Type.GEOPOINT, 12, "geography", new Integer[]{12, -1, -9});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if (sqlType == 3 || sqlType == 2) {
            return new SchemaColumn(name, sqlScale == 0 ? Type.BIGINT : Type.DOUBLE);
        }
        if ("GEOGRAPHY".equals(sqlTypeName)) {
            return new SchemaColumn(name, Type.GEOMETRY);
        }
        if (sqlType == 2014) {
            return new SchemaColumn(name, Type.DATE);
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        if (sqlType == 91) {
            if (schemaColumn.getType() == Type.DATE) {
                Date dt = rs2.getDate(colIdx);
                if (dt == null) {
                    return null;
                }
                this.ensureThreadLocalsAreHere();
                String s = this.dateOnlyParser.get().format(dt) + " 00:00:00.000";
                DateTimeFormatter sdf = DateTimeFormat.forPattern((String)"yyyy-MM-dd 00:00:00.000").withZone(assumedTz);
                return ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print((ReadableInstant)sdf.parseDateTime(s)) + "Z";
            }
            return rs2.getString(colIdx);
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        logger.trace(() -> "Casting " + expr + " from " + String.valueOf(exprType) + " to " + String.valueOf(requestedType));
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR CAST(" + expr + " AS VARCHAR(100)) = '' THEN NULL ELSE CAST(" + expr + " AS BOOLEAN) END";
        }
        if (requestedType == Type.GEOPOINT || requestedType == Type.GEOMETRY) {
            return "TO_GEOGRAPHY(" + expr + ")";
        }
        if ((exprType == Type.GEOPOINT || exprType == Type.GEOMETRY) && requestedType == Type.STRING) {
            return "ST_ASTEXT(" + expr + ")";
        }
        if (requestedType == Type.DATE) {
            if (expr != null && expr.startsWith("'") && !expr.endsWith("Z'")) {
                return "CONVERT_TIMEZONE('UTC', CONCAT(CAST(" + expr + " AS TIMESTAMP_NTZ), '+00:00'))";
            }
            return "CAST(" + expr + " AS TIMESTAMP_TZ)";
        }
        if (requestedType == Type.DATEONLY && exprType == Type.DATE) {
            return "CAST(CONVERT_TIMEZONE('UTC', CAST(" + expr + " AS TIMESTAMP_TZ)) AS DATE)";
        }
        String sqlType = requestedType == Type.STRING ? "VARCHAR" : this.getSQLType((Type)requestedType, (int)maxLength, (String)expr).sqlDecl.toUpperCase(Locale.ENGLISH);
        return "CAST(" + expr + " AS " + sqlType + ")";
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case TINYINT: {
                ps2.setShort(colIdx, Short.parseShort(dssStrVal));
                break;
            }
            case GEOMETRY: 
            case GEOPOINT: {
                ps2.setString(colIdx, dssStrVal);
                break;
            }
            case DATETIMENOTZ: {
                long timestamp = this.typeDatetimeNoTz.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                this.ensureThreadLocalsAreHere();
                ps2.setObject(colIdx, (Object)new Timestamp(timestamp), 50002);
                break;
            }
            default: {
                super.fill(ps2, dssType, colIdx, dssStrVal);
            }
        }
    }

    @Override
    public boolean supportsNonCapturingGroups() {
        return false;
    }

    @Override
    public boolean supportsLookAroundExpressions() {
        return false;
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public boolean supportsNamedWindows() {
        return false;
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return columnName;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 0x1000000;
    }

    @Override
    public String useUTCTimezone() {
        return "ALTER SESSION SET TIMEZONE = 'UTC'";
    }

    @Override
    public String escapeSchemaOrTableNameForJDBCMetadataQuerying(String identifier) {
        if (identifier == null) {
            return null;
        }
        return identifier.replace("_", "\\_");
    }

    @Override
    public boolean isCatalogAware() {
        return true;
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR(EXTRACT(NANOSECOND FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))/1000000)";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(WEEKISO FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case DAY_OF_WEEK: {
                return "EXTRACT(DAYOFWEEKISO FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
            case MILLIS_FROM_EPOCH: {
                return "EXTRACT(EPOCH_MILLISECOND FROM (CONVERT_TIMEZONE('UTC', " + inputDateExpression + ")))";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Snowflake", part));
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(WEEKISO FROM " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "EXTRACT(DAYOFWEEKISO FROM " + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM " + inputDateExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(EXTRACT(EPOCH FROM " + inputDateExpression + ") * 1000)";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Snowflake", part));
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        switch (part) {
            case DAY_OF_MONTH: {
                return "EXTRACT(DAY FROM " + inputDateExpression + ")";
            }
            case HOUR_OF_DAY: {
                return "EXTRACT(HOUR FROM " + inputDateExpression + ")";
            }
            case MINUTE_OF_HOUR: {
                return "EXTRACT(MINUTE FROM " + inputDateExpression + ")";
            }
            case SECOND_OF_MINUTE: {
                return "EXTRACT(SECOND FROM " + inputDateExpression + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "FLOOR(EXTRACT(NANOSECOND FROM " + inputDateExpression + ")/1000000)";
            }
            case MONTH_OF_YEAR: {
                return "EXTRACT(MONTH FROM " + inputDateExpression + ")";
            }
            case WEEK_OF_YEAR: {
                return "EXTRACT(WEEKISO FROM " + inputDateExpression + ")";
            }
            case QUARTER_OF_YEAR: {
                return "EXTRACT(QUARTER FROM " + inputDateExpression + ")";
            }
            case YEAR: {
                return "EXTRACT(YEAR FROM " + inputDateExpression + ")";
            }
            case DAY_OF_WEEK: {
                return "EXTRACT(DAYOFWEEKISO FROM " + inputDateExpression + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM " + inputDateExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "EXTRACT(EPOCH_MILLISECOND FROM " + inputDateExpression + ")";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on Snowflake", part));
    }

    private String atGmtTimezone(String dateExpression) {
        return "CONVERT_TIMEZONE('UTC'," + dateExpression + ")";
    }

    @Override
    public String quoteDate(String str) {
        return "TO_TIMESTAMP_TZ(CONCAT(" + this.quoteString(str) + ", '+00'))";
    }

    @Override
    public String quoteDateOnly(String str) {
        return "TO_DATE(" + this.quoteString(str) + ")";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "TO_TIMESTAMP(" + this.quoteString(str) + ")";
    }

    @Override
    public boolean needsBackslashDoubling() {
        return true;
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        String dateAtGmt = this.atGmtTimezone(inputDateExpression);
        switch (rounding) {
            case DAY: {
                return "date_trunc('DAY'," + dateAtGmt + ")";
            }
            case HOUR: {
                return "date_trunc('HOUR'," + dateAtGmt + ")";
            }
            case WEEK: {
                return "date_trunc('WEEK'," + dateAtGmt + ")";
            }
            case MONTH: {
                return "date_trunc('MONTH'," + dateAtGmt + ")";
            }
            case YEAR: {
                return "date_trunc('YEAR'," + dateAtGmt + ")";
            }
            case QUARTER: {
                return "date_trunc('QUARTER'," + dateAtGmt + ")";
            }
            case MINUTE: {
                return "date_trunc('MINUTE'," + dateAtGmt + ")";
            }
            case SECOND: {
                return "date_trunc('SECOND'," + dateAtGmt + ")";
            }
        }
        throw new QueryUtils.SQLGenerationException("Datetime with tz trunc with unit '" + String.valueOf(rounding) + "' not implemented for Snowflake");
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "date_trunc('DAY'," + inputDateExpression + ")";
            }
            case WEEK: {
                return "date_trunc('WEEK'," + inputDateExpression + ")";
            }
            case MONTH: {
                return "date_trunc('MONTH'," + inputDateExpression + ")";
            }
            case YEAR: {
                return "date_trunc('YEAR'," + inputDateExpression + ")";
            }
            case QUARTER: {
                return "date_trunc('QUARTER'," + inputDateExpression + ")";
            }
        }
        throw new QueryUtils.SQLGenerationException("Date only trunc with unit '" + rounding.toString() + "' not implemented for " + this.getId());
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        switch (rounding) {
            case DAY: {
                return "date_trunc('DAY'," + inputDateExpression + ")";
            }
            case HOUR: {
                return "date_trunc('HOUR'," + inputDateExpression + ")";
            }
            case WEEK: {
                return "date_trunc('WEEK'," + inputDateExpression + ")";
            }
            case MONTH: {
                return "date_trunc('MONTH'," + inputDateExpression + ")";
            }
            case YEAR: {
                return "date_trunc('YEAR'," + inputDateExpression + ")";
            }
            case QUARTER: {
                return "date_trunc('QUARTER'," + inputDateExpression + ")";
            }
            case MINUTE: {
                return "date_trunc('MINUTE'," + inputDateExpression + ")";
            }
            case SECOND: {
                return "date_trunc('SECOND'," + inputDateExpression + ")";
            }
        }
        throw new QueryUtils.SQLGenerationException("Datetime no tz trunc with unit '" + rounding.toString() + "' not implemented for " + this.getId());
    }

    @Override
    public boolean supportsFromTimezoneNtzOperator() {
        return true;
    }

    @Override
    public boolean supportsCaseInsensitivityRegExp() {
        return true;
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.SHA256, "SHA2(", ", 256)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.SHA512, "SHA2(", ", 512)"));
        this.addOperator(new GenericSQLDialect.ParameterSwitchedFunction(QueryUtils.OperatorType.DATEDIFF).whenValueAt(2, "YEAR", String.class, new MonthsDiffFunction(12)).whenValueAt(2, "QUARTER", String.class, new MonthsDiffFunction(3)).whenValueAt(2, "MONTH", String.class, new MonthsDiffFunction(0)).whenValueAt(2, "WEEK", String.class, new SecondsDiffFunction(604800)).whenValueAt(2, "DAY", String.class, new SecondsDiffFunction(86400)).whenValueAt(2, "HOUR", String.class, new SecondsDiffFunction(3600)).whenValueAt(2, "MINUTE", String.class, new SecondsDiffFunction(60)).whenValueAt(2, "SECOND", String.class, new SecondsDiffFunction(0)).whenOtherValueAt(2, null).whenArgCount(2, new SecondsDiffFunction(0)));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "TO_TIMESTAMP_TZ(CONCAT(", ", '+00'))"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_DATE, "TO_DATE(", ")"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "TO_TIMESTAMP(", ")"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CONCAT, "CONCAT", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                StringBuilder sb = new StringBuilder("CONCAT(").append(this.printArg(args[0]));
                for (int i = 1; i < args.length; ++i) {
                    sb.append(", ").append(this.printArg(args[i]));
                }
                return sb.append(")").toString();
            }

            private String printArg(QueryAst.Expr arg) {
                if (arg instanceof QueryAst.ConstExpr) {
                    return ((QueryAst.ConstExpr)arg).value == null ? "''" : this.toSQLNoBrackets(arg);
                }
                return "IFNULL(TO_VARCHAR(" + this.toSQLNoBrackets(arg) + "), '')";
            }
        });
        this.addOperator(new GenericSQLDialect.ParameterSwitchedFunction(QueryUtils.OperatorType.PERCENTILE_APPROX_AGG).whenValueAtCloseTo(1, 0.5, 1.0E-5, new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, "MEDIAN(", ")")).otherwise(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.PERCENTILE_APPROX_AGG, "APPROX_PERCENTILE(", ")", false)));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE_NTZ, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinMaxNumberOfParameters(args, 1, 3);
                if (args.length == 3) {
                    return String.format("(CONVERT_TIMEZONE(%s, %s, %s)||'Z')::timestamp_tz", this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[2]), this.toSQLNoBrackets(args[0]));
                }
                if (args.length == 2) {
                    return String.format("(CONVERT_TIMEZONE(%s, 'UTC', %s)||'Z')::timestamp_tz", this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[0]));
                }
                assert (args.length == 1);
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinMaxNumberOfParameters(args, 1, 3);
                if (args.length == 3) {
                    return String.format("(CONVERT_TIMEZONE(%s, %s, CONVERT_TIMEZONE('UTC', %s)::timestamp_ntz)||'Z')::timestamp_tz", this.toSQLNoBrackets(args[2]), this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[0]));
                }
                if (args.length == 2) {
                    return String.format("CONVERT_TIMEZONE(%s, %s)", this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[0]));
                }
                assert (args.length == 1);
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.SPLIT, "SPLIT(", ")", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.GET, "GET(", ")", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.REGEX_LIKE, "REGEXP_LIKE(", ")", false));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP_REPLACE", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return SnowflakeSQLDialect.this.generateRegExpReplace(this, args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_SUBSTR, "REGEXP_SUBSTR", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return SnowflakeSQLDialect.this.generateRegExpSubstr(this, args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type requestedType;
                this.validateMinNumberOfParameters(args, 2);
                Object input = this.toSQLNoBrackets(args[0]);
                if (args[0].outputType != null && args[0].outputType.dssType != Type.STRING) {
                    input = "CAST(" + (String)input + " AS VARCHAR)";
                }
                if ((requestedType = this.getParamAs(args[1], Type.class)).isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = SnowflakeSQLDialect.this.toDateFormat(jodaFormat, true);
                    boolean specifiesTimezone = false;
                    for (DKUDateUtils.FormatPatternPart part : DKUDateUtils.parsePattern((String)jodaFormat, (boolean)true)) {
                        specifiesTimezone = part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE;
                    }
                    if (requestedType == Type.DATEONLY) {
                        return "TO_DATE(" + (String)input + ",'" + sqlFormat + "')";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "TO_TIMESTAMP_NTZ(" + (String)input + ",'" + sqlFormat + "')";
                    }
                    String converted = specifiesTimezone ? "TO_TIMESTAMP_TZ(" + (String)input + ",'" + sqlFormat + "')" : "TO_TIMESTAMP_TZ(TO_TIMESTAMP_NTZ(" + (String)input + ",'" + sqlFormat + "') || ' +00:00')";
                    if (StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return converted;
                    }
                    return "TO_TIMESTAMP_TZ(CONVERT_TIMEZONE('" + timezoneId + "', 'UTC', " + converted + "::timestamp_ntz) || ' +00:00')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = SnowflakeSQLDialect.this.toDateFormat(jodaFormat, false);
                    if (requestedType == Type.DATEONLY || requestedType == Type.DATETIMENOTZ) {
                        return "TO_CHAR(" + input + ", '" + sqlFormat + "')";
                    }
                    if (StringUtils.isNotBlank((String)timezoneId) && !StringUtils.equals((String)"UTC", (String)timezoneId)) {
                        return "TO_CHAR(CONVERT_TIMEZONE('UTC', '" + timezoneId + "', CONVERT_TIMEZONE('UTC', " + input + ")::timestamp_ntz), '" + sqlFormat + "')";
                    }
                    return "TO_CHAR(CONVERT_TIMEZONE('UTC', " + input + "), '" + sqlFormat + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new GenericSQLDialect.ParameterSwitchedFunction(QueryUtils.OperatorType.FIRST_VALUE).whenValueAt(1, true, Boolean.class, new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.FIRST_VALUE, "FIRST_VALUE(", ") IGNORE NULLS")).otherwise(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.FIRST_VALUE, "FIRST_VALUE(", ")")));
        this.addOperator(new GenericSQLDialect.ParameterSwitchedFunction(QueryUtils.OperatorType.LAST_VALUE).whenValueAt(1, true, Boolean.class, new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.LAST_VALUE, "LAST_VALUE(", ") IGNORE NULLS")).otherwise(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.LAST_VALUE, "LAST_VALUE(", ")")));
        this.addOperator(new GenericSQLDialect.ParameterSwitchedFunction(QueryUtils.OperatorType.AGG_CONCAT).whenValueAt(2, true, Boolean.class, new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.AGG_CONCAT, "LISTAGG(DISTINCT CAST(", " AS string), ", ")", false)).whenArgCount(2, new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.AGG_CONCAT, "LISTAGG(CAST(", " AS string), ", ")", false)).otherwise(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.AGG_CONCAT, "LISTAGG(CAST(", " AS string))")));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                return "DATEADD(" + unit + "," + addIntLong + "," + datetimeNoTz + ")";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.ATAN2, "ATAN2", QueryUtils.Arity.BINARY);
        this.addGenericFunction(QueryUtils.OperatorType.COSH, "COSH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SINH, "SINH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TANH, "TANH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.DEGREES, "DEGREES", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.RADIANS, "RADIANS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.FACT, "FACTORIAL", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.MEDIAN, "MEDIAN", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DEC2HEX, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                return "TRIM(TO_CHAR((" + input + ")::integer, 'xxxxxxxxxxxxxxxx'))";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.RAND, QueryUtils.Arity.ANY){

            @Override
            protected boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 0 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) throws QueryUtils.SQLGenerationException {
                this.validateNumberOfParameters(args);
                if (args == null || args.length == 0) {
                    return "UNIFORM(0, 1::float, RANDOM())";
                }
                if (args.length == 2) {
                    String min = this.toSQLNoBrackets(args[0]);
                    String max = this.toSQLWithBrackets(args[1]);
                    return String.format("UNIFORM(%1$s, %2$s - 1, RANDOM())", min, max);
                }
                return super.apply(args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.IS_BLANK, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return String.format("(%1$s IS NULL OR TO_CHAR(%1$s)='')", this.toSQLNoBrackets(args[0]));
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.IS_NON_BLANK, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return String.format("(NOT (%1$s IS NULL OR TO_CHAR(%1$s)=''))", this.toSQLNoBrackets(args[0]));
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.STARTS_WITH, "STARTSWITH", false));
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.ENDS_WITH, "ENDSWITH", false));
        this.addGenericFunction(QueryUtils.OperatorType.NOW, "CURRENT_TIMESTAMP", QueryUtils.Arity.NO_ARG);
        this.addOperator(new GenericSQLDialect.SimpleBinaryFunction(QueryUtils.OperatorType.INDEX_OF, "(CHARINDEX(COALESCE(", ", ''), ", ") - 1)", true));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_SIMPLIFY, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                String toleranceDistance = this.toSQLNoBrackets(args[1]);
                return String.format("ST_ASTEXT(ST_SIMPLIFY(TO_GEOGRAPHY(%s),%s))", geometry, toleranceDistance);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE", QueryUtils.Arity.UNARY);
        this.addOperator(new GenericSQLDialect.LikeEscapeOperator(QueryUtils.OperatorType.CONTAINS, false, true));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_AREA, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                return String.format("ST_AREA(TO_GEOGRAPHY(%s))", geometry);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_CENTROID, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                return String.format("ST_CENTROID(TO_GEOGRAPHY(%s))", geometry);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_DISTANCE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry1 = this.toSQLNoBrackets(args[0]);
                String geometry2 = this.toSQLNoBrackets(args[1]);
                return String.format("ST_DISTANCE(TO_GEOGRAPHY(%s), TO_GEOGRAPHY(%s))", geometry1, geometry2);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_LENGTH, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                return String.format("CASE WHEN (SUBSTRING(ST_ASTEXT(TO_GEOGRAPHY(%s)),1,12)='MULTIPOLYGON' OR SUBSTRING(ST_ASTEXT(TO_GEOGRAPHY(%<s)),1,7)='POLYGON') THEN ST_PERIMETER(TO_GEOGRAPHY(%<s)) ELSE ST_LENGTH(TO_GEOGRAPHY(%<s)) END", geometry);
            }
        });
        this.addDistanceBasedOperator(QueryUtils.OperatorType.ST_DWITHIN, "ST_DWITHIN");
        this.addDistanceBasedOperator(QueryUtils.OperatorType.ST_BEYOND, "NOT ST_DWITHIN");
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_EQUALS, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return MessageFormat.format("ST_ASWKB({0}) = ST_ASWKB({1}) OR {0} IS NULL AND {1} IS NULL", this.toSQLNoBrackets(args[0]), this.toSQLNoBrackets(args[1]));
            }
        });
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_CONTAINS, "ST_CONTAINS");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_WITHIN, "ST_WITHIN");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_CROSSES, "ST_CROSSES");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_TOUCHES, "ST_TOUCHES");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_DISJOINT, "ST_DISJOINT");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_OVERLAPS, "ST_OVERLAPS");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_INTERSECTS, "ST_INTERSECTS");
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PERCENTILE_CONT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String column = this.toSQLNoBrackets(args[0]);
                double percentile = this.getParamAs(args[1], Double.class);
                return "PERCENTILE_CONT(" + percentile + ") WITHIN GROUP (ORDER BY " + column + ")";
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.CHAR, "CHR", QueryUtils.Arity.UNARY);
    }

    private void addDistanceBasedOperator(QueryUtils.OperatorType operator, final String sqlFunction) {
        this.addOperator(new QueryUtils.Function(this, operator, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return String.format("%s(%s, %s, %s)", sqlFunction, this.toSQLNoBrackets(args[0]), this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[2]));
            }
        });
    }

    private void addGeometryBinaryOperator(QueryUtils.OperatorType operator, final String sqlFunction) {
        this.addOperator(new QueryUtils.Function(this, operator, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return String.format("%s(to_geography(%s), to_geography(%s))", sqlFunction, this.toSQLNoBrackets(args[0]), this.toSQLNoBrackets(args[1]));
            }
        });
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.NestedMultiLineCommentFinder.META, QuotedPortionFinders.PostgresStringLiteralFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META, QuotedPortionFinders.EscapedStringLiteralFinder.META, QuotedPortionFinders.PostgresDollarQuotedLiteralFinder.META};
    }

    @Override
    public boolean supportRetrieveTableRowCount() {
        return true;
    }

    @Override
    public DatasetRecordCount retrieveTableRowCount(SQLConnectionProvider.SQLConnectionData connectionData, SQLConnectionProvider.SQLConnectionWrapper conn, SQLUtils.SQLTable sqlTable) throws SQLException {
        boolean hasCatalogArg = StringUtils.isNotBlank((String)sqlTable.getCatalog());
        boolean hasSchemaArg = StringUtils.isNotBlank((String)sqlTable.getSchemaNullIfBlank());
        if (hasCatalogArg) {
            try (Statement statement = conn.createStatement();){
                statement.execute("USE DATABASE " + this.quoteIdentifier(sqlTable.getCatalog()));
            }
        }
        String query = String.format("SELECT ROW_COUNT FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE='BASE TABLE' AND TABLE_CATALOG=%s AND TABLE_SCHEMA=%s AND TABLE_NAME=?;", hasCatalogArg ? "?" : "current_database()", hasSchemaArg ? "?" : "current_schema()");
        try (PreparedStatement statement = conn.prepareStatement(query);){
            int argIndex = 1;
            if (hasCatalogArg) {
                statement.setString(argIndex++, sqlTable.getCatalog());
            }
            if (hasSchemaArg) {
                statement.setString(argIndex++, sqlTable.getSchemaNullIfBlank());
            }
            statement.setString(argIndex, sqlTable.getTable());
            if (statement.execute()) {
                try (ResultSet rs2 = statement.getResultSet();){
                    if (rs2.next()) {
                        DatasetRecordCount datasetRecordCount = DatasetRecordCount.exact(rs2.getLong(1));
                        return datasetRecordCount;
                    }
                }
            }
            DatasetRecordCount datasetRecordCount = null;
            return datasetRecordCount;
        }
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return sqlTypeName.equalsIgnoreCase("timestamp") || sqlTypeName.equalsIgnoreCase("timestampntz");
    }

    @Override
    public int getIdentifiersMaxLength() {
        return 255;
    }

    @Override
    public boolean supportsIndexing() {
        return false;
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return false;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public String getQuotedTableFullName(String catalog, String schema, String table) {
        if (StringUtils.isBlank((String)catalog)) {
            if (StringUtils.isBlank((String)schema)) {
                return this.quoteIdentifier(table);
            }
            return this.quoteIdentifier(schema) + "." + this.quoteIdentifier(table);
        }
        String quotedSchema = StringUtils.isBlank((String)schema) ? "" : this.quoteIdentifier(schema);
        return this.quoteIdentifier(catalog) + "." + quotedSchema + "." + this.quoteIdentifier(table);
    }

    @Override
    public String getId() {
        return "Snowflake";
    }

    @Override
    protected boolean supportsCreateOrReplace() {
        return true;
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        String defaultQuery = super.generateTableStatementSQL(connection, dataset, messages, ifNotExist);
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        String tableCommentClause = this.getTableCommentClause(config, dataset, messages);
        if (tableCommentClause != null) {
            return defaultQuery + tableCommentClause;
        }
        return defaultQuery;
    }

    @Override
    public String getCreateOrReplaceTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE OR REPLACE TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n");
        sb.append(this.getCreateTableFieldsSQL(dataset, messages));
        sb.append("\n) COPY GRANTS");
        String tableCommentClause = this.getTableCommentClause(config, dataset, messages);
        if (tableCommentClause != null) {
            sb.append(tableCommentClause);
        }
        return sb.toString();
    }

    @VisibleForTesting
    String getCreateFieldsForTemporaryTableSQL(Dataset dataset, Schema temporaryTableSchema, boolean changeDate) {
        Preconditions.checkNotNull((Object)dataset, (Object)"dataset");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (SchemaColumn col : temporaryTableSchema.getColumns()) {
            if (!first) {
                sb.append(",");
            }
            if (col.getType().isTimestamp() && "date_day".equals(col.originalType)) {
                sb.append("\t" + this.quoteIdentifier(col.getName()) + " date");
            } else if (col.getType().isTimestamp() && "date_milli".equals(col.originalType)) {
                sb.append("\t" + this.quoteIdentifier(col.getName()) + " timestampntz");
            } else if (col.getType().isTimestamp() && "date_micro".equals(col.originalType)) {
                sb.append("\t" + this.quoteIdentifier(col.getName()) + " timestampntz");
            } else if (changeDate && col.getType().isTimestamp()) {
                sb.append("\t" + this.quoteIdentifier(col.getName()) + " varchar(32)");
            } else {
                sb.append("\t" + this.quoteIdentifier(col.getName()) + " " + this.getSQLType((SchemaColumn)col, (Dataset)dataset).sqlDecl);
            }
            sb.append("\n");
            first = false;
        }
        return sb.toString();
    }

    public String generateTempTableStatementSQL(String tempTableName, Dataset outputDataset, Schema temporaryTableSchema, boolean changeDate) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = outputDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(outputDataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TEMPORARY TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, tempTableName) + " (\n");
        sb.append(this.getCreateFieldsForTemporaryTableSQL(outputDataset, temporaryTableSchema, changeDate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case WEEK: 
            case WEEKYEAR: {
                throw new IllegalArgumentException("Formatting to week is not available");
            }
            case DAYOFYEAR: {
                throw new IllegalArgumentException("Formatting to day of year is not available");
            }
            case DAYOFWEEK: {
                if (!part.numeric && part.shortened) {
                    return "DY";
                }
                throw new IllegalArgumentException("Formatting to day of week is not available");
            }
            case MILLISECOND: {
                return "FF";
            }
            case TIMEZONE: {
                if (part.numeric) {
                    return "TZH:TZM";
                }
                throw new IllegalArgumentException("No timezone in snowflake formats (only +/-HH:mm timezones)");
            }
            case MONTH: {
                if (part.numeric) {
                    return "MM";
                }
                if (!forParsing && !part.shortened) {
                    throw new IllegalArgumentException("Cannot format long month names");
                }
                return "MON";
            }
            case TEXT: {
                Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"]");
                if (toEscape.matcher(part.text).matches()) {
                    return "\"" + part.text.replace("\"", "\\\\\"") + "\"";
                }
                return part.text;
            }
        }
        return super.toDateFormatPart(part, forParsing, hasIsoDatePart);
    }

    @Override
    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        if (part.type == DKUDateUtils.FormatPatternPartType.TIMEZONE && !part.numeric) {
            return SQLCapability.nok("Cannot handle textual timezones");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUR || part.type == DKUDateUtils.FormatPatternPartType.CLOCKHOUROFHALFDAY) {
            return SQLCapability.nok("Cannot handle clock hour");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFYEAR) {
            return SQLCapability.nok("Cannot handle day of year");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK && (part.numeric || !part.shortened)) {
            return SQLCapability.nok("Cannot handle numeric or abbreviated day of week");
        }
        if (!(part.type != DKUDateUtils.FormatPatternPartType.MONTH || forParsing || part.numeric || part.shortened)) {
            return SQLCapability.nok("Cannot format to full month name");
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.WEEK || part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR) {
            return SQLCapability.nok("Cannot handle week/year pairs");
        }
        return SQLCapability.ok();
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        return "SELECT table_schema, table_name, table_catalog FROM INFORMATION_SCHEMA.VIEWS WHERE table_name LIKE 'DSSVIEW@_%' ESCAPE '@'" + this.getSchemaConditionForListingViews(schema, "table_schema", "");
    }

    @Override
    public SQLDialect.DefaultUnquotedCase getDefaultUnquotedCaseForTables() {
        return SQLDialect.DefaultUnquotedCase.UPPER;
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.MEDIAN, new SQLAggregateAbility(false, false, true, false));
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true).canWindow(false));
        abilities.put(SQLAggregateType.FIRST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.LAST_NOTNULL, new SQLAggregateAbility(true, true, true, true));
        return abilities;
    }

    @Override
    public boolean canCastDSSFormatToTemporal() {
        return true;
    }

    @Override
    public SQLDialect.RandomSampleClauseLocation getRandomSampleClauseLocation(SamplingParam.SamplingMethod samplingMethod, Long seed) {
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO) {
            return SQLDialect.RandomSampleClauseLocation.FROM;
        }
        if (samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB_EXACT || samplingMethod == SamplingParam.SamplingMethod.RANDOM_FIXED_NB) {
            return seed == null ? SQLDialect.RandomSampleClauseLocation.FROM : SQLDialect.RandomSampleClauseLocation.ORDER_BY_AND_LIMIT;
        }
        return SQLDialect.RandomSampleClauseLocation.NOT_SUPPORTED;
    }

    @Override
    public String getRandomSampleClause(QueryAst.SampleClause sample) {
        StringBuilder sb = new StringBuilder();
        switch (sample.samplingMethod) {
            case RANDOM_FIXED_NB_EXACT: 
            case RANDOM_FIXED_NB: {
                if (sample.seed == null) {
                    sb.append("SAMPLE (").append(sample.rows).append(" ROWS)");
                    break;
                }
                sb.append("RANDOM(").append(sample.seed).append(")");
                break;
            }
            case RANDOM_FIXED_RATIO: {
                sb.append("SAMPLE (").append(sample.ratio * 100.0).append(")");
                if (sample.seed == null) break;
                sb.append(" SEED (").append(sample.seed).append(")");
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(sample.samplingMethod) + " sampling is not available for Snowflake");
            }
        }
        return sb.toString();
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLUtils.MergeIntoUpsertWriter(this, false, false, false, false);
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.UpdateFromUpdateSelectWriter(this, false, false);
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableLikeMaterializedTemporaryTableWriter(this, true, false);
    }

    @Override
    public SQLUtils.SQLTable getSafeRandomTemporaryTableName(String catalog, String schema, String prefix, String suffix) {
        return new SQLUtils.SQLTable(catalog, schema, this.getSafeRandomTemporaryTableName(prefix) + suffix);
    }

    @Override
    public String generateTableCommentStatementQuery(AbstractSQLDatasetHandler.AbstractSQLConfig config, String description, InfoMessage.InfoMessages messages) {
        return "COMMENT IF EXISTS ON TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(description, config.table, true, messages));
    }

    @Override
    public String generateColumnCommentStatementQuery(AbstractSQLDatasetHandler.AbstractSQLConfig config, SchemaColumn column, InfoMessage.InfoMessages messages) {
        return "COMMENT IF EXISTS ON COLUMN " + this.getQuotedColumnFullName(config.catalog, config.schema, config.table, column.getName()) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(column.comment, column.getName(), false, messages)) + ";";
    }

    @Override
    public boolean supportsWriteSQLComment() {
        return true;
    }

    @Override
    public boolean supportsCommentsInCreateTableStatement() {
        return true;
    }

    private String getTableCommentClause(AbstractSQLDatasetHandler.AbstractSQLConfig config, Dataset dataset, InfoMessage.InfoMessages messages) {
        if (config.writeDescriptionsAsSQLComment && dataset.getModel() != null && !StringUtils.isEmpty((String)dataset.getModel().description)) {
            return String.format("\n  COMMENT=%s", this.quoteString(this.truncateDescription(dataset.getModel().description, dataset.getName(), true, messages)));
        }
        return null;
    }

    @Override
    public int getMaxTableCommentLengthInChars() {
        return this.getMaxPossibleVarcharLen();
    }

    @Override
    public int getMaxColumnCommentLengthInChars() {
        return this.getMaxPossibleVarcharLen();
    }

    public class MonthsDiffFunction
    extends QueryUtils.Function {
        private final int truncateBy;

        public MonthsDiffFunction(int truncateBy) {
            super(SnowflakeSQLDialect.this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY);
            this.truncateBy = truncateBy;
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            String end = this.toSQLNoBrackets(args[0]);
            String start = this.toSQLNoBrackets(args[1]);
            String monthDiff = this.generateMonthDiffStatement(start, end);
            if (this.truncateBy <= 0) {
                return monthDiff;
            }
            return "TRUNC((" + monthDiff + ")/" + this.truncateBy + ")";
        }

        private String generateMonthDiffStatement(String start, String end) {
            String utcStart = SnowflakeSQLDialect.this.atGmtTimezone(start);
            String utcEnd = SnowflakeSQLDialect.this.atGmtTimezone(end);
            String secondDiff = "DATEDIFF(SECOND, TO_TIME(" + utcStart + "), TO_TIME(" + utcEnd + "))";
            String dayDiff = SnowflakeSQLDialect.this.datePartExpression(end, DatePart.DAY_OF_MONTH) + "-" + SnowflakeSQLDialect.this.datePartExpression(start, DatePart.DAY_OF_MONTH);
            String monthDiff = "DATEDIFF(MONTH, " + utcStart + ", " + utcEnd + ")";
            return monthDiff + " - (CASE WHEN (" + dayDiff + ")*" + monthDiff + " < 0 OR (" + dayDiff + ") = 0 AND (" + secondDiff + ")*" + monthDiff + " < 0 THEN SIGN(" + monthDiff + ") ELSE 0 END)";
        }
    }

    public class SecondsDiffFunction
    extends QueryUtils.Function {
        private final int truncateBy;

        public SecondsDiffFunction(int truncateBy) {
            super(SnowflakeSQLDialect.this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY);
            this.truncateBy = truncateBy;
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            String end = this.toSQLNoBrackets(args[0]);
            String start = this.toSQLNoBrackets(args[1]);
            String secondsDiff = "DATEDIFF(SECOND, " + start + ", " + end + ")";
            if (this.truncateBy <= 0) {
                return secondsDiff;
            }
            return "TRUNC(" + secondsDiff + "/" + this.truncateBy + ")";
        }
    }
}

