/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.sql.AbstractSparkSQLDialect;
import com.dataiku.dip.sql.SQLUtils;

public class SparkSQLDialect
extends AbstractSparkSQLDialect {
    @Override
    public String getId() {
        return "SparkSQL";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        if (HadoopFlavorUtils.isHDP3()) {
            return new String[]{"CREATE VIEW " + this.getQuotedTableFullName(table) + " AS " + selectExpr};
        }
        return super.createTemporaryTableAs(table, selectExpr);
    }

    @Override
    public String dropTemporaryTable(SQLUtils.SQLTable table) {
        if (HadoopFlavorUtils.isHDP3()) {
            return "DROP VIEW " + this.getQuotedTableFullName(table);
        }
        return super.dropTemporaryTable(table);
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        throw new IllegalStateException("unreachable");
    }

    @Override
    public boolean mustForceOutputColumnNameOverrides() {
        return true;
    }

    public String createTemporaryViewAs(String viewName, String sqlQuery) {
        return "CREATE TEMPORARY VIEW " + viewName + " AS " + sqlQuery;
    }
}

