/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.sqs;

import com.dataiku.dip.streaming.endpoints.sqs.JSONSQSFormat;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.sqs.SQSFormatSerializer;
import com.dataiku.dip.streaming.endpoints.sqs.SQSStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.sqs.StringSQSFormat;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.api.client.util.Preconditions;

public class SQSFormatsFactory {
    public static SQSFormatDeserializer getDeserializer(SQSStreamingEndpointParams params) {
        Preconditions.checkNotNull((Object)params.formatType);
        switch (params.formatType) {
            case "json": {
                JSONSQSFormat.JSONSQSFormatParams fparams = (JSONSQSFormat.JSONSQSFormatParams)JSON.parse((String)JSON.json((Object)params.formatParams), JSONSQSFormat.JSONSQSFormatParams.class);
                return new JSONSQSFormat.JSONSQSFormatDeserializer(fparams);
            }
            case "string": {
                StringSQSFormat.StringSQSFormatParams fparams = (StringSQSFormat.StringSQSFormatParams)JSON.parse((String)JSON.json((Object)params.formatParams), StringSQSFormat.StringSQSFormatParams.class);
                return new StringSQSFormat.StringSQSFormatDeserializer(fparams);
            }
        }
        throw new Error("invalid format");
    }

    public static SQSFormatSerializer getSerializer(SQSStreamingEndpointParams params) {
        Preconditions.checkNotNull((Object)params.formatType);
        switch (params.formatType) {
            case "json": {
                JSONSQSFormat.JSONSQSFormatParams fparams = (JSONSQSFormat.JSONSQSFormatParams)JSON.parse((String)JSON.json((Object)params.formatParams), JSONSQSFormat.JSONSQSFormatParams.class);
                return new JSONSQSFormat.JSONSQSFormatSerializer(fparams);
            }
            case "string": {
                StringSQSFormat.StringSQSFormatParams fparams = (StringSQSFormat.StringSQSFormatParams)JSON.parse((String)JSON.json((Object)params.formatParams), StringSQSFormat.StringSQSFormatParams.class);
                return new StringSQSFormat.StringSQSFormatSerializer(fparams);
            }
        }
        throw new Error("invalid format");
    }
}

