/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.timelines;

import com.dataiku.dip.coremodel.HeadWithVersioningInfo;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.timelines.ITimelinesDBService;
import com.dataiku.dip.timelines.ProjectTimeline;
import com.dataiku.dip.timelines.ProjectTimelineBehavior;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTimelinesService
implements ITimelinesDBService {
    private static final int MAX_TIMELINE_ITEMS_TO_EXPORT = 1000000;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.timelines");

    @Override
    public DSSDBConnection acquireConnection(String projectKey) throws CodedSQLException {
        return this.acquireConnection(projectKey, false);
    }

    @Override
    public void clearForProject(String projectKey) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            dao.delete(conn);
        }
    }

    @Override
    public void changeObjectId(String projectKey, ITaggingService.TaggableType objectType, String oldId, String newId) throws CodedSQLException {
        if (newId == null || newId.equals(oldId)) {
            return;
        }
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            dao.changeObjectId(conn, objectType, oldId, newId);
        }
    }

    @Override
    public void flagDeletedUser(List<String> projectKeys, String user) {
        for (String projectKey : projectKeys) {
            try {
                ProjectTimelineBehavior dao = this.getDao(projectKey);
                DSSDBConnection conn = this.acquireConnection(projectKey);
                try {
                    dao.flagDeletedUser(conn, user);
                }
                finally {
                    if (conn == null) continue;
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Failed to delete user in project timeline %s.", new Object[]{projectKey});
            }
        }
    }

    @Override
    public void deleteObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        try {
            ProjectTimelineBehavior dao = this.getDao(projectKey);
            try (DSSDBConnection conn = this.acquireConnection(projectKey);){
                dao.deleteObject(conn, objectType, objectId);
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Failed to remove object from project timeline %s", new Object[]{projectKey});
        }
    }

    @Override
    public List<String> getContributorsForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        List<String> list;
        block8: {
            ProjectTimelineBehavior dao = this.getDao(projectKey);
            DSSDBConnection conn = this.acquireConnection(projectKey);
            try {
                list = dao.listContributors(conn, objectType, objectId);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to get contributors for %s (%s, %s)", new Object[]{objectType, projectKey, objectId});
                    return new ArrayList<String>();
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public List<String> getContributorsForWiki(String projectKey) {
        List<String> list;
        block8: {
            ProjectTimelineBehavior dao = this.getDao(projectKey);
            DSSDBConnection conn = this.acquireConnection(projectKey);
            try {
                list = dao.listContributorsForWiki(conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, "Failed to get contributors for wiki %s", new Object[]{projectKey});
                    return new ArrayList<String>();
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public void insert(TimelineItem ti) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection(ti.projectKey);){
            this.getDao(ti.projectKey).insert(conn, ti);
        }
    }

    @Override
    public void update(TimelineItem ti) throws CodedSQLException {
        try (DSSDBConnection conn = this.acquireConnection(ti.projectKey);){
            this.getDao(ti.projectKey).update(conn, ti);
        }
    }

    @Override
    public TimelinesService.TimelineWithVersioning getForProject(String projectKey, int from, int limit) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            TimelinesService.TimelineWithVersioning timelineWithVersioning = dao.getForProject(conn, from, limit);
            return timelineWithVersioning;
        }
    }

    @Override
    public ProjectTimeline getForProjectExport(String projectKey) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            ProjectTimeline projectTimeline = dao.getTimeLineItemsForProject(conn, 0, 1000000);
            return projectTimeline;
        }
    }

    @Override
    public TimelinesService.TimelineWithVersioning getForWiki(String projectKey, int from, int limit) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            TimelinesService.TimelineWithVersioning timelineWithVersioning = dao.getForWiki(conn, from, limit);
            return timelineWithVersioning;
        }
    }

    @Override
    public List<TimelineItem> getForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId, int from, int limit) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            List<TimelineItem> list = dao.getForObject(conn, objectType, objectId, from, limit);
            return list;
        }
    }

    @Override
    public TimelineItem getFirstForObjectNoCache(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            TimelineItem timelineItem = dao.getFirstForObjectNoCache(conn, objectType, objectId);
            return timelineItem;
        }
    }

    @Override
    public TimelineItem getFirstForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            TimelineItem timelineItem = dao.getFirstForObject(conn, objectType, objectId);
            return timelineItem;
        }
    }

    @Override
    public TimelineItem getLatestForObject(ITaggingService.TaggableType objectType, String projectKey, String objectId) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey);){
            TimelineItem timelineItem = dao.getLatestForObject(conn, objectType, objectId);
            return timelineItem;
        }
    }

    @Override
    public Pair<TimelineItem, TimelineItem> getLatestForProjectAndLatestForProjectAndUser(String projectKey, String user) throws CodedSQLException {
        ProjectTimelineBehavior dao = this.getDao(projectKey);
        try (DSSDBConnection conn = this.acquireConnection(projectKey, true);){
            Pair pair = new Pair((Object)dao.getLatest(conn), (Object)dao.getLatestForUser(conn, user));
            return pair;
        }
    }

    @Override
    public List<String> getContributors(String projectKey) throws CodedSQLException {
        return this.getDao(projectKey).getContributors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> getRecentTimelineItems(List<String> projects, final long since) {
        final ConcurrentHashMap<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>> ret = new ConcurrentHashMap<TaggableObjectsService.TaggableObjectRef, List<TimelineItem>>();
        ExecutorService exec = Executors.newFixedThreadPool(8);
        try {
            for (final String projectKey : projects) {
                exec.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProjectTimelineBehavior dao = AbstractTimelinesService.this.getDao(projectKey);
                            try (DSSDBConnection conn = AbstractTimelinesService.this.acquireConnection(projectKey);){
                                ret.putAll(dao.getRecent(conn, since));
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)("Failed to read timeline for project " + projectKey), (Throwable)e);
                        }
                    }
                });
            }
        }
        finally {
            exec.shutdown();
        }
        AbstractTimelinesService.awaitTermination(exec);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo> getCreationAndUpdateInfoForAllObjects(List<String> projectKeys) {
        final ConcurrentHashMap<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo> ret = new ConcurrentHashMap<TaggableObjectsService.TaggableObjectRef, HeadWithVersioningInfo>();
        ExecutorService exec = Executors.newFixedThreadPool(8);
        try {
            for (final String projectKey : projectKeys) {
                exec.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProjectTimelineBehavior dao = AbstractTimelinesService.this.getDao(projectKey);
                            try (DSSDBConnection conn = AbstractTimelinesService.this.acquireConnection(projectKey);){
                                ret.putAll(dao.getCreationAndUpdateInfoForAllObjects(conn));
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)("Failed to read timeline for project " + projectKey), (Throwable)e);
                        }
                    }
                });
            }
        }
        finally {
            exec.shutdown();
        }
        AbstractTimelinesService.awaitTermination(exec);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaggableObjectsService.TaggableObjectRef, Collection<String>> getContributorsForAllObjects(List<String> projectKeys) {
        final ConcurrentHashMap<TaggableObjectsService.TaggableObjectRef, Collection<String>> ret = new ConcurrentHashMap<TaggableObjectsService.TaggableObjectRef, Collection<String>>();
        ExecutorService exec = Executors.newFixedThreadPool(8);
        try {
            for (final String projectKey : projectKeys) {
                exec.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProjectTimelineBehavior dao = AbstractTimelinesService.this.getDao(projectKey);
                            try (DSSDBConnection conn = AbstractTimelinesService.this.acquireConnection(projectKey);){
                                Map<TaggableObjectsService.TaggableObjectRef, Collection<String>> x = dao.getContributorsForAllObjects(conn);
                                ret.putAll(x);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)("Failed to read timeline for project " + projectKey), (Throwable)e);
                        }
                    }
                });
            }
        }
        finally {
            exec.shutdown();
        }
        AbstractTimelinesService.awaitTermination(exec);
        return ret;
    }

    private static void awaitTermination(ExecutorService exec) {
        try {
            exec.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.info((Object)"Execution interrupted", (Throwable)e);
        }
    }
}

