/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.utils.DKULogger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractUnifiedMonitoringQueueHandler
implements Runnable {
    private final BlockingQueue<BackendEvent> queue = new LinkedBlockingQueue<BackendEvent>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.unifiedMonitoringQueueHandler");

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                BackendEvent event = this.queue.take();
                try {
                    DKULogger.startCurrentCall();
                    logger.debugV("Handling event type=%s", new Object[]{event.getName()});
                    this.handleQueueEvent(event);
                    logger.debugV("Done handling event type=%s", new Object[]{event.getName()});
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Failed to handle event of type %s", event.getName()), (Throwable)e);
                }
                finally {
                    DKULogger.endCurrentCall();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Unified monitoring queue handler thread interrupted", (Throwable)e);
        }
    }

    public void addEvent(BackendEvent event) {
        this.queue.add(event);
    }

    public abstract void handleQueueEvent(BackendEvent var1);
}

