/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.model.serverconfig;

import com.dataiku.dss.shadelib.com.nimbusds.jose.jwk.JWKSet;
import java.text.ParseException;
import java.util.Objects;

public class OAuth2Config {
    public String issuer;
    public KeysFormat keysFormat = KeysFormat.JWKS_URI;
    public String jwksUri;
    public int jwkUriConnectTimeout = 500;
    public int jwkUriReadTimeout = 500;
    public int jwkUriSizeLimit = 51200;
    public boolean disableSSLCertificatesCheck = false;
    public String jwksSet;
    public String audience;
    public String scope;
    public ScopeClaimFormat scopeClaimFormat = ScopeClaimFormat.STRING;
    public String scopeClaimKey = "scope";
    public String clientIdClaimKey;
    private JWKSet jwkSetParsed = null;

    public JWKSet getJwksSet() throws ParseException {
        if (this.jwkSetParsed == null) {
            this.jwkSetParsed = JWKSet.parse((String)this.jwksSet);
        }
        return this.jwkSetParsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Config that = (OAuth2Config)o;
        return this.jwkUriConnectTimeout == that.jwkUriConnectTimeout && this.jwkUriReadTimeout == that.jwkUriReadTimeout && this.disableSSLCertificatesCheck == that.disableSSLCertificatesCheck && this.jwkUriSizeLimit == that.jwkUriSizeLimit && Objects.equals(this.issuer, that.issuer) && this.keysFormat == that.keysFormat && Objects.equals(this.jwksUri, that.jwksUri) && Objects.equals(this.jwksSet, that.jwksSet) && Objects.equals(this.audience, that.audience) && Objects.equals(this.scope, that.scope) && this.scopeClaimFormat == that.scopeClaimFormat && Objects.equals(this.scopeClaimKey, that.scopeClaimKey) && Objects.equals(this.clientIdClaimKey, that.clientIdClaimKey) && Objects.equals(this.jwkSetParsed, that.jwkSetParsed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.issuer, this.keysFormat, this.jwksUri, this.disableSSLCertificatesCheck, this.jwkUriConnectTimeout, this.jwkUriReadTimeout, this.jwkUriSizeLimit, this.jwksSet, this.audience, this.scope, this.scopeClaimFormat, this.scopeClaimKey, this.clientIdClaimKey, this.jwkSetParsed});
    }

    public static enum KeysFormat {
        JWKS_URI,
        STATIC_JWKS;

    }

    public static enum ScopeClaimFormat {
        STRING,
        ARRAY;

    }
}

