/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.LocalTime;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DKUFormulaUtils {
    DateTimeFormatter isoDateFormatter = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
    DateTimeFormatter dateOnlyFormatter = DKUDateUtils.ymdDashOrSlash().withZone(DateTimeZone.UTC);
    DateTimeFormatter datetimeNoTzFormatter = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser()).appendLiteral(' ').append(ISODateTimeFormat.hourMinuteSecond()).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(1, 9).toParser()).toFormatter();

    public Object asTemporal(Object o) {
        return DKUFormulaUtils.asTemporal(o, false, this.isoDateFormatter, this.dateOnlyFormatter, this.datetimeNoTzFormatter);
    }

    public Object asTemporal(Object o, Properties bindings) {
        return DKUFormulaUtils.asTemporal(o, bindings.containsKey("UDAF_COLUMNS_BLOCKS_KEY"), this.isoDateFormatter, this.dateOnlyFormatter, this.datetimeNoTzFormatter);
    }

    public static Object asTemporal(Object o, boolean treatDoubleAsDate, DateTimeFormatter isoDateFormatter, DateTimeFormatter dateOnlyFormatter, DateTimeFormatter datetimeNoTzFormatter) {
        if (o == null) {
            return null;
        }
        if (o instanceof DateTime || o instanceof LocalDate || o instanceof LocalDateTime) {
            return o;
        }
        if (o instanceof Date || o instanceof Calendar || o instanceof Double && treatDoubleAsDate) {
            long t = o instanceof Date ? ((Date)o).getTime() : (o instanceof Calendar ? ((Calendar)o).getTime().getTime() : ((Double)o).longValue());
            return new DateTime(t);
        }
        if (isoDateFormatter == null || dateOnlyFormatter == null || datetimeNoTzFormatter == null) {
            return null;
        }
        String s = o.toString();
        if (s.length() < 19) {
            return dateOnlyFormatter.parseLocalDate(s);
        }
        if (s.charAt(10) == ' ') {
            return datetimeNoTzFormatter.parseLocalDateTime(s);
        }
        return isoDateFormatter.parseDateTime(s);
    }

    public DateTime asDate(Object o) {
        return DKUFormulaUtils.asDate(o, false, this.isoDateFormatter);
    }

    public DateTime asDate(Object o, Properties bindings) {
        return DKUFormulaUtils.asDate(o, bindings.containsKey("UDAF_COLUMNS_BLOCKS_KEY"), this.isoDateFormatter);
    }

    public static DateTime asDate(Object o, boolean treatDoubleAsDate, DateTimeFormatter isoFormatter) {
        if (o == null) {
            return null;
        }
        if (o instanceof DateTime) {
            return (DateTime)o;
        }
        if (o instanceof Date) {
            return new DateTime(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new DateTime((Object)((Calendar)o).getTime());
        }
        if (o instanceof Double && treatDoubleAsDate) {
            return new DateTime(((Double)o).longValue());
        }
        if (o instanceof LocalDate) {
            return ((LocalDate)o).toDateTime(LocalTime.MIDNIGHT, DateTimeZone.UTC);
        }
        if (o instanceof LocalDateTime) {
            return ((LocalDateTime)o).toDateTime(DateTimeZone.UTC);
        }
        if (isoFormatter == null) {
            return null;
        }
        return isoFormatter.parseDateTime(o.toString());
    }

    public LocalDate asDateOnly(Object o) {
        return DKUFormulaUtils.asDateOnly(o, false, this.dateOnlyFormatter);
    }

    public LocalDate asDateOnly(Object o, Properties bindings) {
        return DKUFormulaUtils.asDateOnly(o, bindings.containsKey("UDAF_COLUMNS_BLOCKS_KEY"), this.dateOnlyFormatter);
    }

    public static LocalDate asDateOnly(Object o, boolean treatDoubleAsDate, DateTimeFormatter isoFormatter) {
        if (o == null) {
            return null;
        }
        if (o instanceof LocalDate) {
            return (LocalDate)o;
        }
        if (o instanceof Date) {
            return new LocalDate(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new LocalDate((Object)((Calendar)o).getTime());
        }
        if (o instanceof Double && treatDoubleAsDate) {
            return new LocalDate(((Double)o).longValue());
        }
        if (o instanceof LocalDateTime) {
            return ((LocalDateTime)o).toLocalDate();
        }
        if (o instanceof DateTime) {
            return ((DateTime)o).toLocalDate();
        }
        if (isoFormatter == null) {
            return null;
        }
        return isoFormatter.parseLocalDate(o.toString());
    }

    public LocalDateTime asDatetimeNoTz(Object o) {
        return DKUFormulaUtils.asDatetimeNoTz(o, false, this.datetimeNoTzFormatter);
    }

    public LocalDateTime asDatetimeNoTz(Object o, Properties bindings) {
        return DKUFormulaUtils.asDatetimeNoTz(o, bindings.containsKey("UDAF_COLUMNS_BLOCKS_KEY"), this.datetimeNoTzFormatter);
    }

    public static LocalDateTime asDatetimeNoTz(Object o, boolean treatDoubleAsDate, DateTimeFormatter isoFormatter) {
        if (o == null) {
            return null;
        }
        if (o instanceof LocalDateTime) {
            return (LocalDateTime)o;
        }
        if (o instanceof Date) {
            return new LocalDateTime(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new LocalDateTime((Object)((Calendar)o).getTime());
        }
        if (o instanceof Double && treatDoubleAsDate) {
            return new LocalDateTime(((Double)o).longValue());
        }
        if (o instanceof LocalDate) {
            return ((LocalDate)o).toLocalDateTime(LocalTime.MIDNIGHT);
        }
        if (o instanceof DateTime) {
            return ((DateTime)o).toLocalDateTime();
        }
        if (isoFormatter == null) {
            return null;
        }
        return isoFormatter.parseLocalDateTime(o.toString());
    }

    public static List<?> asList(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Object[]) {
            Object[] arr = (Object[])o;
            return Arrays.asList(arr);
        }
        if (o instanceof JSONArray) {
            ArrayList<Object> l = new ArrayList<Object>();
            JSONArray arr = (JSONArray)o;
            for (int i = 0; i < arr.length(); ++i) {
                try {
                    l.add(arr.get(i));
                    continue;
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException("Unexpected error:" + e.getMessage());
                }
            }
            return l;
        }
        if (o instanceof List) {
            return (List)o;
        }
        try {
            ArrayList<Object> l = new ArrayList<Object>();
            JSONArray arr = new JSONArray(o.toString());
            for (int i = 0; i < arr.length(); ++i) {
                l.add(arr.get(i));
            }
            return l;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Could not parse value (" + o.toString() + " ) as list: " + e.getMessage());
        }
    }

    public static JSONObject asJSONObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        try {
            return new JSONObject(o.toString());
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Could not parse value (" + o.toString() + " ) as an Object: " + e.getMessage());
        }
    }

    public static boolean isNotABlankString(Object arg) {
        return !(arg instanceof String) || StringUtils.isNotBlank((String)((String)arg));
    }

    public static List<?> asList(Object[] args) {
        List<Object> convertedList = Arrays.asList(args);
        if (args.length == 1 && args[0] != null) {
            try {
                convertedList = DKUFormulaUtils.asList(args[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return convertedList;
    }
}

