/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.math.BigInteger;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class Dec2Hex
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0 || args[0] == null || args[0] instanceof String && StringUtils.isBlank((String)((String)args[0]))) {
            return null;
        }
        if (args.length == 1) {
            try {
                String arg = args[0].toString().trim();
                return new BigInteger(arg).toString(16);
            }
            catch (Exception e) {
                return null;
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects only 1 argument");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Dec2Hex.DOCUMENTATION", "Returns an hexadecimal representation of the input number.").withParams("long").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("10").returns("a")).withExample(Example.with("256").returns("100"));
    }
}

