/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.geo;

import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.buffer.BufferOp;

public class GeoBuffer
implements Function {
    private static final GeometryMeaning geometryMeaning = new GeometryMeaning();

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length < 2 || args.length > 3) {
            return new EvalError(String.format("%s requires two to three  arguments)", GrelControlFunctionRegistry.getInstance().getFunctionName(this)));
        }
        Object geometry = args[0];
        Object distance = args[1];
        if (distance == null) {
            return new EvalError("distance parameter expects a number");
        }
        if (geometry instanceof String && !StringUtils.isBlank((String)((String)geometry))) {
            Geometry bufferOp;
            Geometry parsedGeometry = geometryMeaning.toGeometry((String)geometry);
            if (parsedGeometry == null) {
                return new EvalError("geometry parameter doesn't contain geospatial data");
            }
            if (!(distance instanceof Number)) {
                return new EvalError("Cannot parse to double : distance");
            }
            double maximumDistance = ((Number)distance).doubleValue();
            int quadrantSegment = 8;
            if (args.length == 3 && args[2] != null) {
                if (args[2] instanceof Number) {
                    quadrantSegment = ((Number)args[2]).intValue();
                } else {
                    return new EvalError("quadrantSegment parameter expects a number");
                }
            }
            if ((bufferOp = BufferOp.bufferOp((Geometry)parsedGeometry, (double)maximumDistance, (int)quadrantSegment)) == null) {
                return new EvalError("Failed to create the buffer");
            }
            String buffer = bufferOp.toString();
            return "POLYGON EMPTY".equals(buffer) ? null : buffer;
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.GeoBuffer.DOCUMENTATION", "Returns a geometry that represents all points whose distance from this geometry is less than or equal to distance. The distance units depends on the CRS of the given geometries. (Ex: degrees for SRID=4326) A negative distance can be used with polygons, which will shrink the polygon rather than expanding it. The quadrantSegment parameter is the number of segments to approximate a quarter circle, default to 8").withParams("string geometry, double distance, [int quadrantSegment]").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.GEO", "Geo functions").withExample(Example.with("POINT(100 80)", "10", "1").returns("POLYGON((109.99999999999999 80,100 70,90 80,100 85.05112877980659,109.99999999999999 80))")).withExample(Example.with("geometryColumn", "0.1").returns("a column of buffered geometries where 'geometryColumn' is a column name of the dataset")).withExample(Example.with("geometryColumn", "numval('distanceColumn')").returns("a column of buffered geometries with the distances from the original geometries given by the column 'distanceColumn'"));
    }
}

