/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class GreatestCommonDenominator
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2 && args[0] != null && args[0] instanceof Number && args[1] != null && args[1] instanceof Number) {
            return GreatestCommonDenominator.GCD(((Number)args[0]).doubleValue(), ((Number)args[1]).doubleValue());
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects two numbers");
    }

    public static double GCD(double a, double b) {
        return b == 0.0 ? a : GreatestCommonDenominator.GCD(b, a % b);
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.GreatestCommonDenominator.DOCUMENTATION", "Returns the greatest common denominator of the two numbers.").withParams("number d, number e").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("21", "28").returns("7.0"));
    }
}

