/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;

public class Concat
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        StringBuilder sb = new StringBuilder();
        for (Object o : args) {
            if (o == null) continue;
            sb.append(o.toString());
        }
        return sb.toString();
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Concat.DOCUMENTATION", "Returns a string of concatenated values. If one of your columns contains leading 0 (zeros), wrap it in a <code>strval('column_name')</code> to preserve them.").withParams("a1, a2 ...").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"Birds\"", "\" \"", "\"fly\"").returns("\"Birds fly\"")).withExample(Example.with("1", "2", "3").returns("\"123\""));
    }
}

