/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.ast;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.io.ColumnBlock;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.WrappedRow;
import com.google.refine.expr.WrappedVariables;
import com.google.refine.udaf.UdafUtils;
import java.util.Properties;

public class VariableExpr
implements Evaluable {
    public final String _name;

    public VariableExpr(String name) {
        this._name = name;
    }

    @Override
    public Object evaluate(Properties bindings) {
        Object o = this.evaluate_old(bindings);
        return o;
    }

    public Object evaluate_old(Properties bindings) {
        WrappedVariables wvar;
        if (bindings.containsKey(this._name)) {
            return bindings.get(this._name);
        }
        if (bindings.containsKey("row")) {
            WrappedRow wrow = (WrappedRow)bindings.get("row");
            boolean hasCol = false;
            for (Column col : wrow.cf.columns()) {
                if (!col.getName().equals(this._name)) continue;
                hasCol = true;
            }
            if (hasCol) {
                Object v = wrow.getField(this._name, bindings);
                return v != null ? v : "";
            }
        }
        if (bindings.containsKey("variables") && (wvar = (WrappedVariables)bindings.get("variables")).hasValue(this._name)) {
            Object v = wvar.getField(this._name, bindings);
            return v != null ? v : "";
        }
        ColumnBlock columnBlock = UdafUtils.getColumnBlock(bindings, this._name);
        if (columnBlock != null) {
            return UdafUtils.getColumnValue(bindings, columnBlock, columnBlock.getMemoryType() == ColumnBlock.MemoryType.DOUBLE ? null : "");
        }
        if (bindings.containsKey("UDAF_BINDING_KEY")) {
            throw new RuntimeException("Columns must be used inside aggregations.");
        }
        return bindings.containsKey("row") || bindings.containsKey("variables") ? "" : null;
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }
}

