/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public abstract class DSSAbstractPrimitiveJavaObjectInspector
implements DSSBaseInspector,
PrimitiveObjectInspector {
    private DSSBaseInspector parent;
    protected PrimitiveTypeInfo typeInfo;
    static final PrimitiveTypeInfo booleanTypeInfo = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(Boolean.TYPE);
    static final PrimitiveTypeInfo byteTypeInfo = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(Byte.TYPE);
    static final PrimitiveTypeInfo doubleTypeInfo = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(Double.TYPE);
    static final PrimitiveTypeInfo floatTypeInfo = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(Float.TYPE);
    static final PrimitiveTypeInfo intTypeInfo = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(Integer.TYPE);
    static final PrimitiveTypeInfo longTypeInfo = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(Long.TYPE);
    static final PrimitiveTypeInfo shortTypeInfo = (PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(Short.TYPE);

    @Override
    public DSSBaseInspector getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DSSBaseInspector parent) {
        this.parent = parent;
    }

    protected DSSAbstractPrimitiveJavaObjectInspector(PrimitiveTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public Object getPrimitiveJavaObject(Object o) {
        return o;
    }

    public Object copyObject(Object o) {
        return o;
    }

    public boolean preferWritable() {
        return false;
    }

    public Class<?> getJavaPrimitiveClass() {
        return this.typeInfo.getPrimitiveJavaClass();
    }

    public PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory() {
        return this.typeInfo.getPrimitiveCategory();
    }

    public Class<?> getPrimitiveWritableClass() {
        return this.typeInfo.getPrimitiveWritableClass();
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.PRIMITIVE;
    }

    public String getTypeName() {
        return this.typeInfo.getTypeName();
    }

    public PrimitiveTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public int precision() {
        switch (this.typeInfo.getPrimitiveCategory()) {
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case BYTE: {
                return 3;
            }
            case SHORT: {
                return 5;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 19;
            }
            case VOID: {
                return 1;
            }
        }
        return 38;
    }

    public int scale() {
        switch (this.typeInfo.getPrimitiveCategory()) {
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case VOID: {
                return 0;
            }
        }
        return 0;
    }
}

