/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.identity.spi.AwsSessionCredentialsIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsSessionCredentials
implements AwsCredentials,
AwsSessionCredentialsIdentity,
ToCopyableBuilder<Builder, AwsSessionCredentials> {
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final String accountId;
    private final Instant expirationTime;
    private final String providerName;

    private AwsSessionCredentials(Builder builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
        this.accountId = builder.accountId;
        this.expirationTime = builder.expirationTime;
        this.providerName = builder.providerName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AwsSessionCredentials create(String accessKey, String secretKey, String sessionToken) {
        return AwsSessionCredentials.builder().accessKeyId(accessKey).secretAccessKey(secretKey).sessionToken(sessionToken).build();
    }

    @Override
    public String accessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    @Override
    public Optional<Instant> expirationTime() {
        return Optional.ofNullable(this.expirationTime);
    }

    @Override
    public String sessionToken() {
        return this.sessionToken;
    }

    @Override
    public Optional<String> providerName() {
        return Optional.ofNullable(this.providerName);
    }

    @Override
    public Optional<String> accountId() {
        return Optional.ofNullable(this.accountId);
    }

    public String toString() {
        return ToString.builder("AwsSessionCredentials").add("accessKeyId", this.accessKeyId()).add("providerName", this.providerName).add("accountId", this.accountId).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsSessionCredentials that = (AwsSessionCredentials)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretAccessKey, that.secretAccessKey) && Objects.equals(this.sessionToken, that.sessionToken) && Objects.equals(this.accountId, that.accountId().orElse(null)) && Objects.equals(this.expirationTime, that.expirationTime().orElse(null));
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId);
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime);
        return hashCode;
    }

    @Override
    public Builder toBuilder() {
        return AwsSessionCredentials.builder().accessKeyId(this.accessKeyId).secretAccessKey(this.secretAccessKey).sessionToken(this.sessionToken).accountId(this.accountId).expirationTime(this.expirationTime).providerName(this.providerName);
    }

    @Override
    public AwsSessionCredentials copy(Consumer<? super Builder> modifier) {
        return (AwsSessionCredentials)ToCopyableBuilder.super.copy(modifier);
    }

    public static final class Builder
    implements CopyableBuilder<Builder, AwsSessionCredentials> {
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private String accountId;
        private Instant expirationTime;
        private String providerName;

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @Override
        public AwsSessionCredentials build() {
            return new AwsSessionCredentials(this);
        }
    }
}

