/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.ows11.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.opengis.ows11.AbstractReferenceBaseType;
import net.opengis.ows11.AcceptFormatsType;
import net.opengis.ows11.AcceptVersionsType;
import net.opengis.ows11.AddressType;
import net.opengis.ows11.AllowedValuesType;
import net.opengis.ows11.AnyValueType;
import net.opengis.ows11.BasicIdentificationType;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.CapabilitiesBaseType;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.ContactType;
import net.opengis.ows11.ContentsBaseType;
import net.opengis.ows11.DCPType;
import net.opengis.ows11.DatasetDescriptionSummaryBaseType;
import net.opengis.ows11.DescriptionType;
import net.opengis.ows11.DocumentRoot;
import net.opengis.ows11.DomainMetadataType;
import net.opengis.ows11.DomainType;
import net.opengis.ows11.ExceptionReportType;
import net.opengis.ows11.ExceptionType;
import net.opengis.ows11.GetCapabilitiesType;
import net.opengis.ows11.GetResourceByIdType;
import net.opengis.ows11.HTTPType;
import net.opengis.ows11.IdentificationType;
import net.opengis.ows11.KeywordsType;
import net.opengis.ows11.LanguageStringType;
import net.opengis.ows11.ManifestType;
import net.opengis.ows11.MetadataType;
import net.opengis.ows11.NoValuesType;
import net.opengis.ows11.OnlineResourceType;
import net.opengis.ows11.OperationType;
import net.opengis.ows11.OperationsMetadataType;
import net.opengis.ows11.Ows11Package;
import net.opengis.ows11.RangeClosureType;
import net.opengis.ows11.RangeType;
import net.opengis.ows11.ReferenceGroupType;
import net.opengis.ows11.ReferenceType;
import net.opengis.ows11.RequestMethodType;
import net.opengis.ows11.ResponsiblePartySubsetType;
import net.opengis.ows11.ResponsiblePartyType;
import net.opengis.ows11.SectionsType;
import net.opengis.ows11.ServiceIdentificationType;
import net.opengis.ows11.ServiceProviderType;
import net.opengis.ows11.ServiceReferenceType;
import net.opengis.ows11.TelephoneType;
import net.opengis.ows11.UnNamedDomainType;
import net.opengis.ows11.ValueType;
import net.opengis.ows11.ValuesReferenceType;
import net.opengis.ows11.WGS84BoundingBoxType;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;

public class Ows11Validator
extends EObjectValidator {
    public static final Ows11Validator INSTANCE = new Ows11Validator();
    public static final String DIAGNOSTIC_SOURCE = "net.opengis.ows11";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    protected XMLTypeValidator xmlType_1Validator = XMLTypeValidator.INSTANCE;
    public static final EValidator.PatternMatcher[][] MIME_TYPE__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"(application|audio|image|text|video|message|multipart|model)/.+(;\\s*.+=.+)*")}};
    public static final EValidator.PatternMatcher[][] VERSION_TYPE__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"\\d+\\.\\d?\\d\\.\\d?\\d")}};
    public static final EValidator.PatternMatcher[][] VERSION_TYPE1__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"\\d+\\.\\d?\\d\\.\\d?\\d")}};

    protected EPackage getEPackage() {
        return Ows11Package.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context) {
        switch (classifierID) {
            case 0: {
                return this.validateAbstractReferenceBaseType((AbstractReferenceBaseType)value, diagnostics, context);
            }
            case 1: {
                return this.validateAcceptFormatsType((AcceptFormatsType)value, diagnostics, context);
            }
            case 2: {
                return this.validateAcceptVersionsType((AcceptVersionsType)value, diagnostics, context);
            }
            case 3: {
                return this.validateAddressType((AddressType)value, diagnostics, context);
            }
            case 4: {
                return this.validateAllowedValuesType((AllowedValuesType)value, diagnostics, context);
            }
            case 5: {
                return this.validateAnyValueType((AnyValueType)value, diagnostics, context);
            }
            case 6: {
                return this.validateBasicIdentificationType((BasicIdentificationType)value, diagnostics, context);
            }
            case 7: {
                return this.validateBoundingBoxType((BoundingBoxType)value, diagnostics, context);
            }
            case 8: {
                return this.validateCapabilitiesBaseType((CapabilitiesBaseType)value, diagnostics, context);
            }
            case 9: {
                return this.validateCodeType((CodeType)value, diagnostics, context);
            }
            case 10: {
                return this.validateContactType((ContactType)value, diagnostics, context);
            }
            case 11: {
                return this.validateContentsBaseType((ContentsBaseType)value, diagnostics, context);
            }
            case 12: {
                return this.validateDatasetDescriptionSummaryBaseType((DatasetDescriptionSummaryBaseType)value, diagnostics, context);
            }
            case 13: {
                return this.validateDCPType((DCPType)value, diagnostics, context);
            }
            case 14: {
                return this.validateDescriptionType((DescriptionType)value, diagnostics, context);
            }
            case 15: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 16: {
                return this.validateDomainMetadataType((DomainMetadataType)value, diagnostics, context);
            }
            case 17: {
                return this.validateDomainType((DomainType)value, diagnostics, context);
            }
            case 18: {
                return this.validateExceptionReportType((ExceptionReportType)value, diagnostics, context);
            }
            case 19: {
                return this.validateExceptionType((ExceptionType)value, diagnostics, context);
            }
            case 20: {
                return this.validateGetCapabilitiesType((GetCapabilitiesType)value, diagnostics, context);
            }
            case 21: {
                return this.validateGetResourceByIdType((GetResourceByIdType)value, diagnostics, context);
            }
            case 22: {
                return this.validateHTTPType((HTTPType)value, diagnostics, context);
            }
            case 23: {
                return this.validateIdentificationType((IdentificationType)value, diagnostics, context);
            }
            case 24: {
                return this.validateKeywordsType((KeywordsType)value, diagnostics, context);
            }
            case 25: {
                return this.validateLanguageStringType((LanguageStringType)value, diagnostics, context);
            }
            case 26: {
                return this.validateManifestType((ManifestType)value, diagnostics, context);
            }
            case 27: {
                return this.validateMetadataType((MetadataType)value, diagnostics, context);
            }
            case 28: {
                return this.validateNoValuesType((NoValuesType)value, diagnostics, context);
            }
            case 29: {
                return this.validateOnlineResourceType((OnlineResourceType)value, diagnostics, context);
            }
            case 30: {
                return this.validateOperationsMetadataType((OperationsMetadataType)value, diagnostics, context);
            }
            case 31: {
                return this.validateOperationType((OperationType)value, diagnostics, context);
            }
            case 32: {
                return this.validateRangeType((RangeType)value, diagnostics, context);
            }
            case 33: {
                return this.validateReferenceGroupType((ReferenceGroupType)value, diagnostics, context);
            }
            case 34: {
                return this.validateReferenceType((ReferenceType)value, diagnostics, context);
            }
            case 35: {
                return this.validateRequestMethodType((RequestMethodType)value, diagnostics, context);
            }
            case 36: {
                return this.validateResponsiblePartySubsetType((ResponsiblePartySubsetType)value, diagnostics, context);
            }
            case 37: {
                return this.validateResponsiblePartyType((ResponsiblePartyType)value, diagnostics, context);
            }
            case 38: {
                return this.validateSectionsType((SectionsType)value, diagnostics, context);
            }
            case 39: {
                return this.validateServiceIdentificationType((ServiceIdentificationType)value, diagnostics, context);
            }
            case 40: {
                return this.validateServiceProviderType((ServiceProviderType)value, diagnostics, context);
            }
            case 41: {
                return this.validateServiceReferenceType((ServiceReferenceType)value, diagnostics, context);
            }
            case 42: {
                return this.validateTelephoneType((TelephoneType)value, diagnostics, context);
            }
            case 43: {
                return this.validateUnNamedDomainType((UnNamedDomainType)value, diagnostics, context);
            }
            case 44: {
                return this.validateValuesReferenceType((ValuesReferenceType)value, diagnostics, context);
            }
            case 45: {
                return this.validateValueType((ValueType)value, diagnostics, context);
            }
            case 46: {
                return this.validateWGS84BoundingBoxType((WGS84BoundingBoxType)value, diagnostics, context);
            }
            case 47: {
                return this.validateRangeClosureType((RangeClosureType)value, diagnostics, context);
            }
            case 48: {
                return this.validateMimeType((String)value, diagnostics, context);
            }
            case 49: {
                return this.validatePositionType((List)value, diagnostics, context);
            }
            case 50: {
                return this.validatePositionType2D((List)value, diagnostics, context);
            }
            case 51: {
                return this.validateRangeClosureTypeObject((RangeClosureType)value, diagnostics, context);
            }
            case 52: {
                return this.validateServiceType((String)value, diagnostics, context);
            }
            case 53: {
                return this.validateUpdateSequenceType((String)value, diagnostics, context);
            }
            case 54: {
                return this.validateVersionType((String)value, diagnostics, context);
            }
            case 55: {
                return this.validateVersionType1((String)value, diagnostics, context);
            }
            case 56: {
                return this.validateMap((Map)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAbstractReferenceBaseType(AbstractReferenceBaseType abstractReferenceBaseType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractReferenceBaseType, diagnostics, context);
    }

    public boolean validateAcceptFormatsType(AcceptFormatsType acceptFormatsType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(acceptFormatsType, diagnostics, context);
    }

    public boolean validateAcceptVersionsType(AcceptVersionsType acceptVersionsType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(acceptVersionsType, diagnostics, context);
    }

    public boolean validateAddressType(AddressType addressType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(addressType, diagnostics, context);
    }

    public boolean validateAllowedValuesType(AllowedValuesType allowedValuesType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(allowedValuesType, diagnostics, context);
    }

    public boolean validateAnyValueType(AnyValueType anyValueType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(anyValueType, diagnostics, context);
    }

    public boolean validateBasicIdentificationType(BasicIdentificationType basicIdentificationType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(basicIdentificationType, diagnostics, context);
    }

    public boolean validateBoundingBoxType(BoundingBoxType boundingBoxType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(boundingBoxType, diagnostics, context);
    }

    public boolean validateCapabilitiesBaseType(CapabilitiesBaseType capabilitiesBaseType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(capabilitiesBaseType, diagnostics, context);
    }

    public boolean validateCodeType(CodeType codeType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(codeType, diagnostics, context);
    }

    public boolean validateContactType(ContactType contactType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(contactType, diagnostics, context);
    }

    public boolean validateContentsBaseType(ContentsBaseType contentsBaseType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(contentsBaseType, diagnostics, context);
    }

    public boolean validateDatasetDescriptionSummaryBaseType(DatasetDescriptionSummaryBaseType datasetDescriptionSummaryBaseType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(datasetDescriptionSummaryBaseType, diagnostics, context);
    }

    public boolean validateDCPType(DCPType dcpType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(dcpType, diagnostics, context);
    }

    public boolean validateDescriptionType(DescriptionType descriptionType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(descriptionType, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateDomainMetadataType(DomainMetadataType domainMetadataType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(domainMetadataType, diagnostics, context);
    }

    public boolean validateDomainType(DomainType domainType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(domainType, diagnostics, context);
    }

    public boolean validateExceptionReportType(ExceptionReportType exceptionReportType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(exceptionReportType, diagnostics, context);
    }

    public boolean validateExceptionType(ExceptionType exceptionType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(exceptionType, diagnostics, context);
    }

    public boolean validateGetCapabilitiesType(GetCapabilitiesType getCapabilitiesType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(getCapabilitiesType, diagnostics, context);
    }

    public boolean validateGetResourceByIdType(GetResourceByIdType getResourceByIdType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(getResourceByIdType, diagnostics, context);
    }

    public boolean validateHTTPType(HTTPType httpType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(httpType, diagnostics, context);
    }

    public boolean validateIdentificationType(IdentificationType identificationType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(identificationType, diagnostics, context);
    }

    public boolean validateKeywordsType(KeywordsType keywordsType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(keywordsType, diagnostics, context);
    }

    public boolean validateLanguageStringType(LanguageStringType languageStringType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(languageStringType, diagnostics, context);
    }

    public boolean validateManifestType(ManifestType manifestType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(manifestType, diagnostics, context);
    }

    public boolean validateMetadataType(MetadataType metadataType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(metadataType, diagnostics, context);
    }

    public boolean validateNoValuesType(NoValuesType noValuesType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(noValuesType, diagnostics, context);
    }

    public boolean validateOnlineResourceType(OnlineResourceType onlineResourceType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(onlineResourceType, diagnostics, context);
    }

    public boolean validateOperationsMetadataType(OperationsMetadataType operationsMetadataType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(operationsMetadataType, diagnostics, context);
    }

    public boolean validateOperationType(OperationType operationType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(operationType, diagnostics, context);
    }

    public boolean validateRangeType(RangeType rangeType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(rangeType, diagnostics, context);
    }

    public boolean validateReferenceGroupType(ReferenceGroupType referenceGroupType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(referenceGroupType, diagnostics, context);
    }

    public boolean validateReferenceType(ReferenceType referenceType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(referenceType, diagnostics, context);
    }

    public boolean validateRequestMethodType(RequestMethodType requestMethodType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(requestMethodType, diagnostics, context);
    }

    public boolean validateResponsiblePartySubsetType(ResponsiblePartySubsetType responsiblePartySubsetType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(responsiblePartySubsetType, diagnostics, context);
    }

    public boolean validateResponsiblePartyType(ResponsiblePartyType responsiblePartyType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(responsiblePartyType, diagnostics, context);
    }

    public boolean validateSectionsType(SectionsType sectionsType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(sectionsType, diagnostics, context);
    }

    public boolean validateServiceIdentificationType(ServiceIdentificationType serviceIdentificationType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(serviceIdentificationType, diagnostics, context);
    }

    public boolean validateServiceProviderType(ServiceProviderType serviceProviderType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(serviceProviderType, diagnostics, context);
    }

    public boolean validateServiceReferenceType(ServiceReferenceType serviceReferenceType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(serviceReferenceType, diagnostics, context);
    }

    public boolean validateTelephoneType(TelephoneType telephoneType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(telephoneType, diagnostics, context);
    }

    public boolean validateUnNamedDomainType(UnNamedDomainType unNamedDomainType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(unNamedDomainType, diagnostics, context);
    }

    public boolean validateValuesReferenceType(ValuesReferenceType valuesReferenceType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(valuesReferenceType, diagnostics, context);
    }

    public boolean validateValueType(ValueType valueType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(valueType, diagnostics, context);
    }

    public boolean validateWGS84BoundingBoxType(WGS84BoundingBoxType wgs84BoundingBoxType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(wgs84BoundingBoxType, diagnostics, context);
    }

    public boolean validateRangeClosureType(RangeClosureType rangeClosureType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateMimeType(String mimeType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateMimeType_Pattern(mimeType, diagnostics, context);
        return result;
    }

    public boolean validateMimeType_Pattern(String mimeType, DiagnosticChain diagnostics, Map context) {
        return this.validatePattern(Ows11Package.Literals.MIME_TYPE, mimeType, MIME_TYPE__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validatePositionType(List positionType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validatePositionType_ItemType(positionType, diagnostics, context);
        return result;
    }

    public boolean validatePositionType_ItemType(List positionType, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator i = positionType.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.DOUBLE.isInstance(item)) {
                result &= this.xmlTypeValidator.validateDouble(((Double)item).doubleValue(), diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.DOUBLE, item, diagnostics, context);
        }
        return result;
    }

    public boolean validatePositionType2D(List positionType2D, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validatePositionType_ItemType(positionType2D, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validatePositionType2D_MinLength(positionType2D, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePositionType2D_MaxLength(positionType2D, diagnostics, context);
        }
        return result;
    }

    public boolean validatePositionType2D_MinLength(List positionType2D, DiagnosticChain diagnostics, Map context) {
        boolean result;
        int length = positionType2D.size();
        boolean bl = result = length >= 2;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(Ows11Package.Literals.POSITION_TYPE2_D, positionType2D, length, 2, diagnostics, context);
        }
        return result;
    }

    public boolean validatePositionType2D_MaxLength(List positionType2D, DiagnosticChain diagnostics, Map context) {
        boolean result;
        int length = positionType2D.size();
        boolean bl = result = length <= 2;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(Ows11Package.Literals.POSITION_TYPE2_D, positionType2D, length, 2, diagnostics, context);
        }
        return result;
    }

    public boolean validateRangeClosureTypeObject(RangeClosureType rangeClosureTypeObject, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateServiceType(String serviceType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateUpdateSequenceType(String updateSequenceType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateVersionType(String versionType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateVersionType_Pattern(versionType, diagnostics, context);
        return result;
    }

    public boolean validateVersionType_Pattern(String versionType, DiagnosticChain diagnostics, Map context) {
        return this.validatePattern(Ows11Package.Literals.VERSION_TYPE, versionType, VERSION_TYPE__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateVersionType1(String versionType1, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateVersionType1_Pattern(versionType1, diagnostics, context);
        return result;
    }

    public boolean validateVersionType1_Pattern(String versionType1, DiagnosticChain diagnostics, Map context) {
        return this.validatePattern(Ows11Package.Literals.VERSION_TYPE1, versionType1, VERSION_TYPE1__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateMap(Map map, DiagnosticChain diagnostics, Map context) {
        return true;
    }
}

