/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.storage;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class XMLHiveInputFormat
extends TextInputFormat {
    public static final String TAG_KEY = "xml.tag";
    public static final Log LOG = LogFactory.getLog((String)XMLHiveInputFormat.class.getName());

    public RecordReader<LongWritable, Text> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        return new XmlRecordReader((FileSplit)inputSplit, jobConf);
    }

    protected boolean isSplitable(FileSystem fs, Path file) {
        return false;
    }

    public static class XmlRecordReader
    implements RecordReader<LongWritable, Text> {
        private final byte[] startTag;
        private final byte[] endTag;
        private final long start;
        private final long end;
        private final InputStream fsin;
        private final DataOutputBuffer buffer = new DataOutputBuffer();

        public XmlRecordReader(FileSplit split, JobConf jobConf) throws IOException {
            String tagKey = jobConf.get(XMLHiveInputFormat.TAG_KEY);
            if (tagKey == null) {
                try {
                    Properties tableProperties = ((PartitionDesc)Utilities.getMapRedWork((Configuration)jobConf).getPathToPartitionInfo().get(FileInputFormat.getInputPaths((JobConf)jobConf)[0].toString())).getTableDesc().getProperties();
                    tagKey = tableProperties.getProperty(XMLHiveInputFormat.TAG_KEY);
                }
                catch (Exception e) {
                    throw new IOException("Unable to retrieve value for xml.tag", e);
                }
                if (tagKey == null) {
                    throw new IOException("Unable to retrieve value for xml.tag");
                }
            }
            String startTagString = "<" + tagKey;
            String endTagString = "</" + tagKey + ">";
            this.startTag = startTagString.getBytes("utf-8");
            this.endTag = endTagString.getBytes("utf-8");
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            Path file = split.getPath();
            FileSystem fs = file.getFileSystem((Configuration)jobConf);
            CompressionCodecFactory compressionCodecs = new CompressionCodecFactory((Configuration)jobConf);
            CompressionCodec codec = compressionCodecs.getCodec(file);
            if (codec != null) {
                this.fsin = codec.createInputStream((InputStream)fs.open(split.getPath()));
                LOG.info((Object)("Initialized XmlRecordReader with codec " + codec.getClass().getName() + " with tag " + tagKey + " to " + split.getPath().toString() + " " + this.start + " " + this.end));
            } else {
                this.fsin = fs.open(split.getPath());
                ((FSDataInputStream)this.fsin).seek(this.start);
                LOG.info((Object)("Initialized XmlRecordReader with no codec  with tag " + tagKey + " to " + split.getPath().toString() + " " + this.start + " " + this.end));
            }
        }

        protected long pos() throws IOException {
            return ((Seekable)this.fsin).getPos();
        }

        protected boolean readUntilSlashOrOpenTag(LongWritable key, Text value, int b) throws IOException {
            while (b != -1) {
                this.writeToBuffer(b);
                if (b == 47) {
                    b = this.fsin.read();
                    this.writeToBuffer(b);
                    if (b == 62) {
                        key.set(this.pos());
                        value.set(this.buffer.getData(), 0, this.buffer.getLength());
                        return true;
                    }
                }
                if (b == 62) {
                    return false;
                }
                b = this.fsin.read();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean next(LongWritable key, Text value) throws IOException {
            if (this.readUntilMatch(this.startTag, false)) {
                try {
                    int b = this.fsin.read();
                    if (Character.isLetterOrDigit(b)) {
                        boolean bl = this.next(key, value);
                        return bl;
                    }
                    this.buffer.write(this.startTag);
                    if (this.readUntilSlashOrOpenTag(key, value, b)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (this.readUntilMatch(this.endTag, true)) {
                        key.set(this.pos());
                        value.set(this.buffer.getData(), 0, this.buffer.getLength());
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.buffer.reset();
                }
            }
            LOG.info((Object)"No Match startTag");
            return false;
        }

        public LongWritable createKey() {
            return new LongWritable();
        }

        public Text createValue() {
            return new Text();
        }

        public long getPos() throws IOException {
            return this.pos();
        }

        public void close() throws IOException {
            this.fsin.close();
        }

        public float getProgress() throws IOException {
            return (float)(this.pos() - this.start) / (float)(this.end - this.start);
        }

        private void writeToBuffer(int b) throws IOException {
            if (b == 10) {
                this.buffer.write(32);
            } else if (b != 13) {
                this.buffer.write(b);
            }
        }

        private boolean readUntilMatch(byte[] match, boolean withinBlock) throws IOException {
            int i = 0;
            int b;
            while ((b = this.fsin.read()) != -1) {
                if (withinBlock) {
                    this.writeToBuffer(b);
                }
                if (b == match[i]) {
                    if (++i < match.length) continue;
                    return true;
                }
                i = 0;
            }
            return false;
        }
    }
}

