/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hive.udf.arrays;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

public class UDFArrayJoin
extends GenericUDF {
    ListObjectInspector arrayInspector;
    ListObjectInspector elementsInspector;
    List<Object> ret = new ArrayList<Object>();

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        if (args.length != 1) {
            return null;
        }
        Object oin = args[0].get();
        if (oin == null) {
            return null;
        }
        int nbArrays = this.arrayInspector.getListLength(oin);
        this.ret.clear();
        for (int i = 0; i < nbArrays; ++i) {
            Object oarr = this.arrayInspector.getListElement(oin, i);
            int nbElts = this.elementsInspector.getListLength(oarr);
            for (int j = 0; j < nbElts; ++j) {
                Object oelt = this.elementsInspector.getListElement(oarr, j);
                this.ret.add(oelt);
            }
        }
        return this.ret;
    }

    public String getDisplayString(String[] args) {
        return "array_join(" + args[0] + ")";
    }

    public ObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length != 1) {
            throw new UDFArgumentException("array_join expects 1 argument");
        }
        if (args[0].getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("array_join expects an array as argument, got " + args[0].getTypeName());
        }
        this.arrayInspector = (ListObjectInspector)args[0];
        ObjectInspector tmpElementsInspector = this.arrayInspector.getListElementObjectInspector();
        if (tmpElementsInspector.getCategory() != ObjectInspector.Category.LIST) {
            throw new UDFArgumentException("array_join expects array<array>, got array<" + tmpElementsInspector.getTypeName() + ">");
        }
        this.elementsInspector = (ListObjectInspector)tmpElementsInspector;
        ObjectInspector elementElementInspector = this.elementsInspector.getListElementObjectInspector();
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)elementElementInspector);
    }
}

