/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.governance;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.governance.AutoGovernanceEffectiveAction;
import com.dataiku.gh.core.models.governance.IGovernanceSettingsValidationService;
import com.dataiku.gh.core.models.governance.IInputGovernanceSettingsVisitor;
import com.dataiku.gh.core.models.governance.InputGovernanceSettings;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.governance.utils.GovernanceUtils;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GovernanceSettingsValidationService
implements IGovernanceSettingsValidationService {
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;

    @Override
    public void validateFromManualGovern(EnrichedArtifact dataikuItemToGovern, InputGovernanceSettings inputGovernanceSettings) throws IOException {
        if (GovernanceUtils.isGoverned(dataikuItemToGovern.artifact)) {
            throw new ValidationException("Artifact of ID `" + dataikuItemToGovern.artifact.id + "` is already governed");
        }
        this.validateActionMatchesAncestorsState(inputGovernanceSettings, dataikuItemToGovern);
    }

    private void validateActionMatchesAncestorsState(InputGovernanceSettings inputGovernanceSettings, final EnrichedArtifact dataikuItemToGovern) throws IOException {
        final List<EnrichedArtifact> ancestry = this.artifactsDataService.getArtifactAndAncestryOfDataikuArtifact(dataikuItemToGovern);
        ancestry.remove(0);
        inputGovernanceSettings.accept(new IInputGovernanceSettingsVisitor(){

            @Override
            public void visit(InputGovernanceSettings.ProjectSettings governanceSettings) {
                if (governanceSettings.action == AutoGovernanceEffectiveAction.GOVERN) {
                    GovernanceSettingsValidationService.throwIfAncestorGoverned(ancestry, dataikuItemToGovern);
                }
                if (governanceSettings.action != AutoGovernanceEffectiveAction.HIDE) {
                    GovernanceSettingsValidationService.throwIfAncestorHidden(ancestry, dataikuItemToGovern);
                }
            }

            @Override
            public void visit(InputGovernanceSettings.ExistingProjectSettings governanceSettings) {
                GovernanceSettingsValidationService.throwIfAncestorGoverned(ancestry, dataikuItemToGovern);
                GovernanceSettingsValidationService.throwIfAncestorHidden(ancestry, dataikuItemToGovern);
            }

            @Override
            public void visit(InputGovernanceSettings.BundleSettings governanceSettings) {
                if (governanceSettings.action == AutoGovernanceEffectiveAction.GOVERN) {
                    GovernanceSettingsValidationService.throwIfAncestorGoverned(ancestry, dataikuItemToGovern);
                }
                if (governanceSettings.action != AutoGovernanceEffectiveAction.HIDE) {
                    GovernanceSettingsValidationService.throwIfAncestorHidden(ancestry, dataikuItemToGovern);
                }
            }

            @Override
            public void visit(InputGovernanceSettings.ModelSettings governanceSettings) {
                if (governanceSettings.action == AutoGovernanceEffectiveAction.GOVERN) {
                    GovernanceSettingsValidationService.throwIfAncestorGoverned(ancestry, dataikuItemToGovern);
                }
                if (governanceSettings.action != AutoGovernanceEffectiveAction.HIDE) {
                    GovernanceSettingsValidationService.throwIfAncestorHidden(ancestry, dataikuItemToGovern);
                }
            }

            @Override
            public void visit(InputGovernanceSettings.ModelVersionSettings governanceSettings) {
                if (governanceSettings.action == AutoGovernanceEffectiveAction.GOVERN) {
                    GovernanceSettingsValidationService.throwIfAncestorGoverned(ancestry, dataikuItemToGovern);
                }
                if (governanceSettings.action != AutoGovernanceEffectiveAction.HIDE) {
                    GovernanceSettingsValidationService.throwIfAncestorHidden(ancestry, dataikuItemToGovern);
                }
            }
        });
    }

    private static void throwIfAncestorGoverned(List<EnrichedArtifact> ancestry, EnrichedArtifact dataikuItemToGovern) {
        if (ancestry.stream().anyMatch(parent -> !GovernanceUtils.isGoverned(parent.artifact))) {
            String governErrorTemplate = "Govern action is not available on artifact with id `%s` because a parent is not governed";
            throw new ValidationException(String.format(governErrorTemplate, dataikuItemToGovern.artifact.id));
        }
    }

    private static void throwIfAncestorHidden(List<EnrichedArtifact> ancestry, EnrichedArtifact dataikuItemToGovern) {
        if (ancestry.stream().anyMatch(parent -> GovernanceUtils.isHidden(parent.artifact))) {
            String hideErrorTemplate = "Only hide action is available on artifact with id `%s` because parent is hidden";
            throw new ValidationException(String.format(hideErrorTemplate, dataikuItemToGovern.artifact.id));
        }
    }

    @Override
    public void validateInputSettings(final EnrichedArtifact dataikuItemToGovern, InputGovernanceSettings inputGovernanceSettings) throws IOException {
        BlueprintVersionId bpvToCreate = GovernanceUtils.extractGoverningBlueprintVersion(inputGovernanceSettings);
        if (bpvToCreate != null) {
            EnrichedBlueprintVersion governingEnrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersionOrNull(bpvToCreate);
            if (governingEnrichedBlueprintVersion == null) {
                throw new ValidationException("Cannot govern with a non-existing blueprint version: " + bpvToCreate.blueprintId + ", " + bpvToCreate.versionId);
            }
            if (governingEnrichedBlueprintVersion.blueprintVersionTrace.status != BlueprintVersionStatus.ACTIVE) {
                throw new ValidationException("Cannot govern with a non-active blueprint version: " + governingEnrichedBlueprintVersion.blueprintVersion.id.blueprintId + ", " + governingEnrichedBlueprintVersion.blueprintVersion.id.versionId);
            }
        }
        final String bpvSettingsMismatchErrorTemplate = "Invalid Govern Setting, received a %s while governing the artifact " + dataikuItemToGovern.artifact.id + " of type " + String.valueOf(dataikuItemToGovern.artifact.blueprintVersionId);
        inputGovernanceSettings.accept(new IInputGovernanceSettingsVisitor(){

            @Override
            public void visit(InputGovernanceSettings.ProjectSettings governanceSettings) {
                String businessInitiativeArtifactId;
                if (!SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(dataikuItemToGovern.artifact.blueprintVersionId)) {
                    throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "create project settings"));
                }
                if (governanceSettings.action == AutoGovernanceEffectiveAction.GOVERN) {
                    if (governanceSettings.blueprintVersionId == null) {
                        throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "null BPV"));
                    }
                    if (!SystemProvidedConstants.GOVERN_PROJECT.matchBlueprint(governanceSettings.blueprintVersionId)) {
                        throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, governanceSettings.blueprintVersionId));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(businessInitiativeArtifactId = governanceSettings.businessInitiativeArtifactId))) {
                    try {
                        EnrichedArtifact businessInitiativeEnrichedArtifact = GovernanceSettingsValidationService.this.artifactsDataService.getArtifact(businessInitiativeArtifactId);
                        if (!SystemProvidedConstants.BUSINESS_INITIATIVE.matchBlueprint(businessInitiativeEnrichedArtifact.blueprint.id)) {
                            throw new ValidationException("The artifactId `" + businessInitiativeArtifactId + "` given for the Dataiku Govern Initiative doesn't reference a Dataiku Govern Initiative but a " + businessInitiativeEnrichedArtifact.blueprint.id);
                        }
                    }
                    catch (IOException e) {
                        throw new ValidationException("Can't access referenced business initiative " + businessInitiativeArtifactId + " when governing " + dataikuItemToGovern.artifact.id);
                    }
                }
            }

            @Override
            public void visit(InputGovernanceSettings.ExistingProjectSettings governanceSettings) {
                if (!SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(dataikuItemToGovern.artifact.blueprintVersionId)) {
                    throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "existing project settings"));
                }
                try {
                    EnrichedArtifact governProjectArtifact = GovernanceSettingsValidationService.this.artifactsDataService.getArtifact(governanceSettings.artifactId);
                    if (!StringUtils.equals((CharSequence)governProjectArtifact.blueprint.id, (CharSequence)SystemProvidedConstants.GOVERN_PROJECT.blueprintId)) {
                        throw new ValidationException("The artifactId `" + governanceSettings.artifactId + "` given for the Dataiku Govern Project doesn't reference a Dataiku Govern Project but a " + governProjectArtifact.blueprint.id);
                    }
                }
                catch (IOException e) {
                    throw new ValidationException("Can't access referenced project " + governanceSettings.artifactId + " when governing " + dataikuItemToGovern.artifact.id);
                }
            }

            @Override
            public void visit(InputGovernanceSettings.BundleSettings governanceSettings) {
                if (!SystemProvidedConstants.DATAIKU_BUNDLE.matchBlueprint(dataikuItemToGovern.artifact.blueprintVersionId)) {
                    throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "bundle settings"));
                }
                if (governanceSettings.action == AutoGovernanceEffectiveAction.GOVERN) {
                    if (governanceSettings.blueprintVersionId == null) {
                        throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "null BPV"));
                    }
                    if (!SystemProvidedConstants.GOVERN_BUNDLE.matchBlueprint(governanceSettings.blueprintVersionId)) {
                        throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, governanceSettings.blueprintVersionId));
                    }
                }
            }

            @Override
            public void visit(InputGovernanceSettings.ModelSettings governanceSettings) {
                if (!SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(dataikuItemToGovern.artifact.blueprintVersionId)) {
                    throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "model settings"));
                }
                if (governanceSettings.action == AutoGovernanceEffectiveAction.GOVERN) {
                    if (governanceSettings.blueprintVersionId == null) {
                        throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "null BPV"));
                    }
                    if (!SystemProvidedConstants.GOVERN_MODEL.matchBlueprint(governanceSettings.blueprintVersionId)) {
                        throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, governanceSettings.blueprintVersionId));
                    }
                }
            }

            @Override
            public void visit(InputGovernanceSettings.ModelVersionSettings governanceSettings) {
                if (!SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.matchBlueprint(dataikuItemToGovern.artifact.blueprintVersionId)) {
                    throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "model version settings"));
                }
                if (governanceSettings.action == AutoGovernanceEffectiveAction.GOVERN) {
                    if (governanceSettings.blueprintVersionId == null) {
                        throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, "null BPV"));
                    }
                    if (!SystemProvidedConstants.GOVERN_MODEL_VERSION.matchBlueprint(governanceSettings.blueprintVersionId)) {
                        throw new ValidationException(String.format(bpvSettingsMismatchErrorTemplate, governanceSettings.blueprintVersionId));
                    }
                }
            }
        });
    }
}

