/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.ui;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionTrace;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.security.PublicGlobalAPIKey;
import com.dataiku.gh.core.models.security.PublicGroup;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.security.model.PublicUser;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections4.iterators.ReverseListIterator;

@UIModel
public class UIArtifact {
    public Artifact artifact;
    public Blueprint blueprint;
    public BlueprintVersion blueprintVersion;
    public BlueprintVersionTrace blueprintVersionTrace;
    public AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx;
    @UINullable
    public List<Signoff> signoffs;
    @UINullable
    public Subscription.SubscriptionLevel subscriptionLevel;
    public UIArtifactDetails uiArtifactDetails = new UIArtifactDetails();
    public UIBlueprintVersion.UIBlueprintVersionDetails uiBlueprintVersionDetails = new UIBlueprintVersion.UIBlueprintVersionDetails();

    @Nullable
    public String getFurthestFinishedStepId() {
        ReverseListIterator reverseListIterator = new ReverseListIterator(this.blueprintVersion.workflowDefinition.stepDefinitions);
        while (reverseListIterator.hasNext()) {
            StepDefinition stepDefinition = (StepDefinition)reverseListIterator.next();
            ArtifactWorkflowStep artifactWorkflowStep = this.artifact.workflow.steps.get(stepDefinition.id);
            if (artifactWorkflowStep == null || !artifactWorkflowStep.isFinished()) continue;
            return stepDefinition.id;
        }
        return null;
    }

    @UIModel
    public static class UIArtifactDetails {
        @UINullable
        public PublicUser user;
        @UINullable
        public PublicGroup group;
        @UINullable
        public PublicGlobalAPIKey globalAPIKey;
        @UINullable
        public String dataikuLink;
    }
}

