/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships.handlers;

import com.dataiku.gh.core.models.relationships.Relationship;
import com.dataiku.gh.core.services.relationships.handlers.IRelationshipHandler;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.IRelationshipDAO;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractRelationshipHandler<T extends Relationship>
implements IRelationshipHandler<T> {
    @Override
    @GHMandatoryTransaction
    public List<T> getRelationshipsForArtifactId(String artifactId) throws IOException {
        return this.getDAO().getRelationshipsForArtifactId(artifactId);
    }

    @Override
    @GHMandatoryTransaction
    public void createRelationships(List<T> relationships) throws IOException {
        this.getDAO().createRelationships(relationships);
    }

    @Override
    @GHMandatoryTransaction
    public void saveRelationships(List<T> relationships) throws IOException {
        this.getDAO().saveRelationships(relationships);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteRelationships(List<T> relationships) throws IOException {
        this.getDAO().deleteRelationships(relationships);
    }

    @Override
    @GHMandatoryTransaction
    public List<T> getRelationshipsByEntityId(String relationshipEntityId) throws IOException {
        return this.getDAO().getRelationships(Collections.singletonList(relationshipEntityId));
    }

    protected abstract IRelationshipDAO<T> getDAO();

    protected void validateUniqueRelationships(List<T> relationships) throws IOException {
        Map<String, List> relationshipMap = relationships.stream().collect(Collectors.toMap(Relationship::getEntityId, xva$0 -> Lists.newArrayList((Object[])new Relationship[]{xva$0}), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }));
        List<T> storedRelationships = this.getDAO().getRelationships(new ArrayList<String>(relationshipMap.keySet()));
        for (Relationship storedRelationship : storedRelationships) {
            Collection relationshipsForRelationshipEntityId = relationshipMap.getOrDefault(storedRelationship.getEntityId(), Collections.emptyList());
            for (Relationship relationship : relationshipsForRelationshipEntityId) {
                if (Objects.equals(relationship.getArtifactId(), storedRelationship.getArtifactId())) continue;
                throw new ValidationException("Item with id " + relationship.getEntityId() + " is already referenced by artifact " + storedRelationship.getArtifactId());
            }
        }
    }
}

