/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.commons.ArtifactMatrixChartSettings;
import com.dataiku.gh.core.models.commons.ArtifactMatrixSettings;
import com.dataiku.gh.core.models.commons.ArtifactTableSettings;
import com.dataiku.gh.core.models.commons.BlueprintIdViewIdPair;
import com.dataiku.gh.core.models.custom_pages.ArtifactKanbanViewCustomPage;
import com.dataiku.gh.core.models.custom_pages.ArtifactMatrixCustomPage;
import com.dataiku.gh.core.models.custom_pages.ArtifactSearchSettings;
import com.dataiku.gh.core.models.custom_pages.ArtifactTableCustomPage;
import com.dataiku.gh.core.models.custom_pages.CustomHTMLCustomPage;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.models.custom_pages.StandardCustomPage;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.services.validation.validators.ArtifactFilterValidator;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.core.visitors.ICustomPageVisitor;
import org.apache.commons.lang3.StringUtils;

public class CustomPageValidator
extends ArtifactFilterValidator
implements ICustomPageVisitor {
    @Override
    public void visit(ArtifactTableCustomPage customPage) {
        this.validateBasicCustomPageAttributes(customPage);
    }

    @Override
    public void visit(ArtifactSearchSettings artifactSearchSettings) {
    }

    @Override
    public void visit(ArtifactTableSettings artifactTableSettings) {
    }

    @Override
    public void visit(ArtifactMatrixCustomPage customPage) {
        this.validateBasicCustomPageAttributes(customPage);
    }

    @Override
    public void visit(ArtifactKanbanViewCustomPage customPage) {
        this.validateBasicCustomPageAttributes(customPage);
    }

    @Override
    public void visit(CustomHTMLCustomPage customPage) {
        this.validateBasicCustomPageAttributes(customPage);
    }

    @Override
    public void visit(StandardCustomPage standardPage) {
        this.validateBasicCustomPageAttributes(standardPage, true);
    }

    @Override
    public void visit(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource) {
    }

    @Override
    public void visit(BlueprintIdViewIdPair blueprintIdViewIdPair) {
        ValidatorUtils.validateThat(IdentifiersUtils.isValidBlueprintId(blueprintIdViewIdPair.blueprintId), "Field 'blueprintId' is not valid on BlueprintIdViewIdPair", new Object[0]);
        ValidatorUtils.validateThat(!StringUtils.isBlank((CharSequence)blueprintIdViewIdPair.viewId), "Field 'viewId' is required on BlueprintIdViewIdPair", new Object[0]);
    }

    @Override
    public void visit(ArtifactMatrixSettings artifactMatrixSettings) {
    }

    @Override
    public void visit(ArtifactMatrixChartSettings artifactMatrixChartSettings) {
        ValidatorUtils.validateThat(artifactMatrixChartSettings.xMaxValue > artifactMatrixChartSettings.xMinValue, "Field 'xMaxValue' must be greater than 'xMinValue' on 'ArtifactMatrixChartSettings'", new Object[0]);
        ValidatorUtils.validateThat(artifactMatrixChartSettings.yMaxValue > artifactMatrixChartSettings.yMinValue, "Field 'yMaxValue' must be greater than 'yMinValue' on 'ArtifactMatrixChartSettings'", new Object[0]);
    }

    private void validateBasicCustomPageAttributes(CustomPage customPage) {
        this.validateBasicCustomPageAttributes(customPage, false);
    }

    private void validateBasicCustomPageAttributes(CustomPage customPage, boolean ignoreNameAndIcon) {
        ValidatorUtils.validateThat(!StringUtils.isBlank((CharSequence)customPage.id), "Custom page id is required", new Object[0]);
        if (!ignoreNameAndIcon) {
            ValidatorUtils.validateThat(!StringUtils.isBlank((CharSequence)customPage.name), "Custom page name is required", new Object[0]);
            ValidatorUtils.validateThat(!StringUtils.isBlank((CharSequence)customPage.icon), "Custom page icon is required", new Object[0]);
        }
    }
}

