/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.util.Arrays;

public class DerivativesGenerator
implements Processor {
    private static final long serialVersionUID = 0L;
    private final String[] columns;
    private final String[] logNames;
    private final String[] sqrtNames;
    private final String[] squareNames;

    public DerivativesGenerator(String[] columns) {
        this.columns = columns;
        this.logNames = new String[columns.length];
        this.sqrtNames = new String[columns.length];
        this.squareNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String c = columns[i];
            this.logNames[i] = "NUM_DERIVATIVE:log(" + c + ")";
            this.sqrtNames[i] = "NUM_DERIVATIVE:sqrt(" + c + ")";
            this.squareNames[i] = "NUM_DERIVATIVE:" + c + "^2";
        }
    }

    public static String logName(String c) {
        return "NUM_DERIVATIVE:log(" + c + ")";
    }

    public static String sqrtName(String c) {
        return "NUM_DERIVATIVE:sqrt(" + c + ")";
    }

    public static String squareName(String c) {
        return "NUM_DERIVATIVE:" + c + "^2";
    }

    public String[] getColumns() {
        return Arrays.copyOf(this.columns, this.columns.length);
    }

    public String[] getLogNames() {
        return this.logNames;
    }

    public String[] getSqrtNames() {
        return this.sqrtNames;
    }

    public String[] getSquareNames() {
        return this.squareNames;
    }

    private static double log(double x) {
        return x < 0.0 ? 0.0 : Math.log(x + 1.0E-8);
    }

    private static double sqrt(double x) {
        return x <= 0.0 ? 0.0 : Math.sqrt(x);
    }

    @Override
    public void process(RawObservation data) {
        for (int i = 0; i < this.columns.length; ++i) {
            Object val = data.get(this.columns[i]);
            if (val == null) {
                data.put(this.logNames[i], null);
                data.put(this.sqrtNames[i], null);
                data.put(this.squareNames[i], null);
                continue;
            }
            if (val instanceof Double) {
                double d = (Double)val;
                data.put(this.logNames[i], DerivativesGenerator.log(d));
                data.put(this.sqrtNames[i], DerivativesGenerator.sqrt(d));
                data.put(this.squareNames[i], d * d);
                continue;
            }
            data.setError("Invalid format for " + this.columns[i] + " for derivatives generation.");
            return;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("DerivativesGenerator(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]);
            if (i == this.columns.length - 1) continue;
            s.append(" ; ");
        }
        return s.append(")").toString();
    }
}

