/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.util;

import com.dataiku.scoring.Observation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RawObservation
implements Observation,
Iterable<Map.Entry<String, Object>> {
    private static final long serialVersionUID = 0L;
    private final Map<String, Object> data;
    private boolean inError = false;
    private String errorMessage = null;

    public static RawObservation cast(Observation o) {
        if (o == null) {
            throw new IllegalArgumentException("Observation cannot be null");
        }
        if (!(o instanceof RawObservation)) {
            throw new UnsupportedOperationException("Unexpected Observation subtype: " + String.valueOf(o.getClass()));
        }
        return (RawObservation)o;
    }

    public RawObservation(Map<String, Object> data) {
        this.data = data;
    }

    public RawObservation copy() {
        return new RawObservation(new HashMap<String, Object>(this.data));
    }

    public RawObservation() {
        this.data = new HashMap<String, Object>();
    }

    public Map<String, Object> toMap() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public Object put(String key, Object value) {
        return this.data.put(key, value);
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public Double getAsDoubleOrNaN(String key) {
        Object v = this.data.get(key);
        if (v instanceof Double) {
            return (Double)v;
        }
        try {
            return Double.parseDouble((String)v);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public Double getAsDouble(String key) {
        return (Double)this.data.get(key);
    }

    public String getAsString(String key) {
        return (String)this.data.get(key);
    }

    public Object remove(String key) {
        return this.data.remove(key);
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public void setError(String errorMessage) {
        this.inError = true;
        this.errorMessage = errorMessage;
    }

    @Override
    public boolean hasError() {
        return this.inError;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Set<String> keys() {
        return this.data.keySet();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.data.entrySet().iterator();
    }

    public String contents() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.keys()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(k).append(" = ").append(this.get(k));
        }
        return sb.toString();
    }
}

