/*
 * Decompiled with CFR 0.152.
 */
package de.biomedical_imaging.edu.wlu.cs.levy.CG;

import de.biomedical_imaging.edu.wlu.cs.levy.CG.Checker;
import de.biomedical_imaging.edu.wlu.cs.levy.CG.Editor;
import de.biomedical_imaging.edu.wlu.cs.levy.CG.HPoint;
import de.biomedical_imaging.edu.wlu.cs.levy.CG.HRect;
import de.biomedical_imaging.edu.wlu.cs.levy.CG.KeyDuplicateException;
import de.biomedical_imaging.edu.wlu.cs.levy.CG.NearestNeighborList;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KDNode<T>
implements Serializable {
    protected HPoint k;
    T v;
    protected KDNode<T> left;
    protected KDNode<T> right;
    protected boolean deleted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> int edit(HPoint key, Editor<T> editor, KDNode<T> t, int lev, int K) throws KeyDuplicateException {
        KDNode<T> next_node = null;
        int next_lev = (lev + 1) % K;
        KDNode<T> kDNode = t;
        synchronized (kDNode) {
            if (key.equals(t.k)) {
                boolean was_deleted = t.deleted;
                t.v = editor.edit(t.deleted ? null : (Object)t.v);
                boolean bl = t.deleted = t.v == null;
                if (t.deleted == was_deleted) {
                    return 0;
                }
                if (was_deleted) {
                    return 1;
                }
                return -1;
            }
            if (key.coord[lev] > t.k.coord[lev]) {
                next_node = t.right;
                if (next_node == null) {
                    t.right = KDNode.create(key, editor);
                    return t.right.deleted ? 0 : 1;
                }
            } else {
                next_node = t.left;
                if (next_node == null) {
                    t.left = KDNode.create(key, editor);
                    return t.left.deleted ? 0 : 1;
                }
            }
        }
        return KDNode.edit(key, editor, next_node, next_lev, K);
    }

    protected static <T> KDNode<T> create(HPoint key, Editor<T> editor) throws KeyDuplicateException {
        KDNode<Object> t = new KDNode<Object>(key, editor.edit(null));
        if (t.v == null) {
            t.deleted = true;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> boolean del(KDNode<T> t) {
        KDNode<T> kDNode = t;
        synchronized (kDNode) {
            if (!t.deleted) {
                t.deleted = true;
                return true;
            }
        }
        return false;
    }

    protected static <T> KDNode<T> srch(HPoint key, KDNode<T> t, int K) {
        int lev = 0;
        while (t != null) {
            if (!t.deleted && key.equals(t.k)) {
                return t;
            }
            t = key.coord[lev] > t.k.coord[lev] ? t.right : t.left;
            lev = (lev + 1) % K;
        }
        return null;
    }

    protected static <T> void rsearch(HPoint lowk, HPoint uppk, KDNode<T> t, int lev, int K, List<KDNode<T>> v) {
        if (t == null) {
            return;
        }
        if (lowk.coord[lev] <= t.k.coord[lev]) {
            KDNode.rsearch(lowk, uppk, t.left, (lev + 1) % K, K, v);
        }
        if (!t.deleted) {
            int j;
            for (j = 0; j < K && lowk.coord[j] <= t.k.coord[j] && uppk.coord[j] >= t.k.coord[j]; ++j) {
            }
            if (j == K) {
                v.add(t);
            }
        }
        if (uppk.coord[lev] > t.k.coord[lev]) {
            KDNode.rsearch(lowk, uppk, t.right, (lev + 1) % K, K, v);
        }
    }

    protected static <T> void nnbr(KDNode<T> kd, HPoint target, HRect hr, double max_dist_sqd, int lev, int K, NearestNeighborList<KDNode<T>> nnl, Checker<T> checker, long timeout) {
        HRect further_hr;
        KDNode<T> further_kd;
        HRect nearer_hr;
        KDNode<T> nearer_kd;
        boolean target_in_left;
        if (kd == null) {
            return;
        }
        if (timeout > 0L && timeout < System.currentTimeMillis()) {
            return;
        }
        int s = lev % K;
        HPoint pivot = kd.k;
        double pivot_to_target = HPoint.sqrdist(pivot, target);
        HRect left_hr = hr;
        HRect right_hr = (HRect)hr.clone();
        left_hr.max.coord[s] = pivot.coord[s];
        right_hr.min.coord[s] = pivot.coord[s];
        boolean bl = target_in_left = target.coord[s] < pivot.coord[s];
        if (target_in_left) {
            nearer_kd = kd.left;
            nearer_hr = left_hr;
            further_kd = kd.right;
            further_hr = right_hr;
        } else {
            nearer_kd = kd.right;
            nearer_hr = right_hr;
            further_kd = kd.left;
            further_hr = left_hr;
        }
        KDNode.nnbr(nearer_kd, target, nearer_hr, max_dist_sqd, lev + 1, K, nnl, checker, timeout);
        KDNode<T> nearest = nnl.getHighest();
        double dist_sqd = !nnl.isCapacityReached() ? Double.MAX_VALUE : nnl.getMaxPriority();
        max_dist_sqd = Math.min(max_dist_sqd, dist_sqd);
        HPoint closest = further_hr.closest(target);
        if (HPoint.sqrdist(closest, target) < max_dist_sqd) {
            if (pivot_to_target < dist_sqd) {
                nearest = kd;
                dist_sqd = pivot_to_target;
                if (!kd.deleted && (checker == null || checker.usable(kd.v))) {
                    nnl.insert(kd, dist_sqd);
                }
                max_dist_sqd = nnl.isCapacityReached() ? nnl.getMaxPriority() : Double.MAX_VALUE;
            }
            KDNode.nnbr(further_kd, target, further_hr, max_dist_sqd, lev + 1, K, nnl, checker, timeout);
        }
    }

    private KDNode(HPoint key, T val) {
        this.k = key;
        this.v = val;
        this.left = null;
        this.right = null;
        this.deleted = false;
    }

    protected String toString(int depth) {
        String s = this.k + "  " + this.v + (this.deleted ? "*" : "");
        if (this.left != null) {
            s = s + "\n" + KDNode.pad(depth) + "L " + this.left.toString(depth + 1);
        }
        if (this.right != null) {
            s = s + "\n" + KDNode.pad(depth) + "R " + this.right.toString(depth + 1);
        }
        return s;
    }

    private static String pad(int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + " ";
        }
        return s;
    }

    private static void hrcopy(HRect hr_src, HRect hr_dst) {
        KDNode.hpcopy(hr_src.min, hr_dst.min);
        KDNode.hpcopy(hr_src.max, hr_dst.max);
    }

    private static void hpcopy(HPoint hp_src, HPoint hp_dst) {
        for (int i = 0; i < hp_dst.coord.length; ++i) {
            hp_dst.coord[i] = hp_src.coord[i];
        }
    }
}

