/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.api;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.hivecommon.AuthMech;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.ServiceDiscoveryMode;
import com.databricks.client.hivecommon.api.HiveServer2ClientFactory;
import com.databricks.client.hivecommon.api.ServiceDiscoveryFactory;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc.common.CommonUtils;
import com.databricks.client.jdbc42.internal.apache.http.HttpEntity;
import com.databricks.client.jdbc42.internal.apache.http.auth.AuthScope;
import com.databricks.client.jdbc42.internal.apache.http.auth.UsernamePasswordCredentials;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpGet;
import com.databricks.client.jdbc42.internal.apache.http.client.utils.URIBuilder;
import com.databricks.client.jdbc42.internal.apache.http.conn.ssl.SSLSocketFactory;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.CloseableHttpClient;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.databricks.client.jdbc42.internal.apache.http.impl.client.HttpClients;
import com.databricks.client.jdbc42.internal.apache.http.util.EntityUtils;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.JsonNode;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;

public class AOSSExtendedHS2Factory
extends ServiceDiscoveryFactory {
    private static final String CONNECTION_ADDRESS_KEY = "connection_address";
    private static final String HTTP_SCHEME = "http";
    private static final String PORT_KEY = "port";
    private static final String REQUEST_PATH = "/status/json";
    private static final int RUNNING_STATUS = 1;
    private static final String SERVICES_KEY = "services";
    private static final String STATUS_KEY = "status";
    private static final String HTTPS_SCHEME = "https";
    private int m_endpointIdx = 0;
    private Iterator<JsonNode> m_servicesItr;
    private ILogger m_logger;

    @Override
    public boolean supportServiceDiscoveryMode(ServiceDiscoveryMode serviceDiscoveryMode, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[]{serviceDiscoveryMode, iLogger});
        switch (serviceDiscoveryMode) {
            case AOSS: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getNextServer(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, iLogger);
        this.m_logger = iLogger;
        StringBuilder stringBuilder = new StringBuilder();
        while (0 == stringBuilder.length()) {
            Object object;
            JsonNode jsonNode = this.getService(hiveJDBCSettings);
            if (null == jsonNode) {
                return null;
            }
            try {
                if (!this.IsServiceRunning(jsonNode)) continue;
                String string = jsonNode.get(CONNECTION_ADDRESS_KEY).asText();
                object = jsonNode.get(PORT_KEY).asText();
                if (null == string || null == object) continue;
                stringBuilder.append(string).append(":").append((String)object);
            }
            catch (Exception exception) {
                this.m_cacheExp = object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), exception.getMessage()});
                if (exception instanceof ErrorException) {
                    ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                }
                LogUtilities.logDebug(exception.getMessage(), this.m_logger);
            }
        }
        return stringBuilder.toString();
    }

    private void getServices(String string) throws ErrorException {
        Serializable serializable;
        JsonNode jsonNode = null;
        try {
            serializable = new ObjectMapper();
            JsonNode jsonNode2 = serializable.readTree(string);
            jsonNode = jsonNode2.get(SERVICES_KEY);
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), "Parsing response for Spark servers", exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
        if (null == jsonNode) {
            serializable = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), "Parsing response for Spark servers", "Services element not found"});
            throw serializable;
        }
        this.m_servicesItr = jsonNode.elements();
    }

    private String sendAOSSRequest(HiveJDBCSettings hiveJDBCSettings, URI uRI) throws ErrorException, IOException {
        CloseableHttpClient closeableHttpClient;
        Object object;
        HttpGet httpGet = new HttpGet(uRI);
        CloseableHttpResponse closeableHttpResponse = null;
        String string = null;
        BasicCredentialsProvider basicCredentialsProvider = null;
        SSLSocketFactory sSLSocketFactory = null;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(hiveJDBCSettings.m_AOSSSocketTimeout).setConnectTimeout(hiveJDBCSettings.m_timeout).build();
        httpGet.setConfig(requestConfig);
        if (hiveJDBCSettings.m_AOSS_SSLSettings.m_enableSSL) {
            sSLSocketFactory = CommonUtils.getSocketFactory(uRI.getHost(), hiveJDBCSettings.m_AOSS_SSLSettings);
        }
        if (AuthMech.UIDPWD == hiveJDBCSettings.m_AOSS_authMech) {
            basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(hiveJDBCSettings.m_AOSS_username, hiveJDBCSettings.m_AOSS_password));
        }
        if (null != sSLSocketFactory && null != basicCredentialsProvider) {
            object = HttpClients.custom().setDefaultCredentialsProvider(basicCredentialsProvider).setSSLSocketFactory(sSLSocketFactory);
            HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, (HttpClientBuilder)object);
            closeableHttpClient = ((HttpClientBuilder)object).build();
        } else if (null != basicCredentialsProvider) {
            object = HttpClients.custom().setDefaultCredentialsProvider(basicCredentialsProvider);
            HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, (HttpClientBuilder)object);
            closeableHttpClient = ((HttpClientBuilder)object).build();
        } else if (null != sSLSocketFactory) {
            object = HttpClients.custom().setSSLSocketFactory(sSLSocketFactory);
            HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, (HttpClientBuilder)object);
            closeableHttpClient = ((HttpClientBuilder)object).build();
        } else {
            object = HttpClients.custom().setSSLSocketFactory(sSLSocketFactory);
            HiveServer2ClientFactory.applyIdleHttpConnectionExpiry(hiveJDBCSettings, (HttpClientBuilder)object);
            closeableHttpClient = ((HttpClientBuilder)object).build();
        }
        try {
            closeableHttpResponse = closeableHttpClient.execute(httpGet);
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), "Connecting to AlwaysOnSQL service endpoint", exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
        finally {
            closeableHttpClient.close();
        }
        object = closeableHttpResponse.getEntity();
        try {
            string = EntityUtils.toString((HttpEntity)object);
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), "Connecting to AlwaysOnSQL service endpoint", exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
        return string;
    }

    private JsonNode getService(HiveJDBCSettings hiveJDBCSettings) {
        while (null == this.m_servicesItr || !this.m_servicesItr.hasNext()) {
            Object object;
            String string = this.getServiceEndpoint(hiveJDBCSettings);
            if (null == string) {
                return null;
            }
            try {
                URI uRI = this.buildURIForHostPortPair(string, hiveJDBCSettings.m_AOSS_SSLSettings.m_enableSSL);
                object = this.sendAOSSRequest(hiveJDBCSettings, uRI);
                this.getServices((String)object);
            }
            catch (Exception exception) {
                if (exception instanceof ErrorException) {
                    ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                }
                LogUtilities.logDebug(exception.getMessage(), this.m_logger);
                this.m_cacheExp = object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{String.valueOf((Object)hiveJDBCSettings.m_serviceDiscoveryMode), "Failed to retrieve service"});
            }
        }
        return this.m_servicesItr.next();
    }

    private String getServiceEndpoint(HiveJDBCSettings hiveJDBCSettings) {
        if (this.m_endpointIdx < hiveJDBCSettings.m_serviceDiscoveryEndpoints.length) {
            String string = hiveJDBCSettings.m_serviceDiscoveryEndpoints[this.m_endpointIdx];
            ++this.m_endpointIdx;
            return string;
        }
        return null;
    }

    private URI buildURIForHostPortPair(String string, boolean bl) throws ErrorException {
        String[] stringArray = string.split(":");
        if (2 != stringArray.length) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), "Building AlwaysOnSQL URI", "AlwaysOnSQL host and port are of an invalid format: " + string});
            throw errorException;
        }
        try {
            int n = Integer.parseInt(stringArray[1]);
            String string2 = bl ? HTTPS_SCHEME : HTTP_SCHEME;
            return new URIBuilder().setScheme(string2).setHost(stringArray[0]).setPort(n).setPath(REQUEST_PATH).build();
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), "Building AlwaysOnSQL URI", exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
    }

    private boolean IsServiceRunning(JsonNode jsonNode) throws ErrorException {
        try {
            int n = jsonNode.get(STATUS_KEY).asInt();
            return n == 1;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_GENERAL_ERROR.name(), new String[]{ServiceDiscoveryMode.AOSS.toString(), "Parsing response for Spark servers", "Status element is of an unknown format"});
            errorException.initCause(exception);
            throw errorException;
        }
    }
}

