/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateNetworkInsightsPathRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.PathRequestFilter;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.RequestFilterPortRange;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateNetworkInsightsPathRequestMarshaller
implements Marshaller<Request<CreateNetworkInsightsPathRequest>, CreateNetworkInsightsPathRequest> {
    @Override
    public Request<CreateNetworkInsightsPathRequest> marshall(CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest) {
        PathRequestFilter filterAtDestination;
        SdkInternalList createNetworkInsightsPathRequestTagSpecificationsList;
        if (createNetworkInsightsPathRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateNetworkInsightsPathRequest> request = new DefaultRequest<CreateNetworkInsightsPathRequest>(createNetworkInsightsPathRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkInsightsPath");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInsightsPathRequest.getSourceIp() != null) {
            request.addParameter("SourceIp", StringUtils.fromString(createNetworkInsightsPathRequest.getSourceIp()));
        }
        if (createNetworkInsightsPathRequest.getDestinationIp() != null) {
            request.addParameter("DestinationIp", StringUtils.fromString(createNetworkInsightsPathRequest.getDestinationIp()));
        }
        if (createNetworkInsightsPathRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(createNetworkInsightsPathRequest.getSource()));
        }
        if (createNetworkInsightsPathRequest.getDestination() != null) {
            request.addParameter("Destination", StringUtils.fromString(createNetworkInsightsPathRequest.getDestination()));
        }
        if (createNetworkInsightsPathRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(createNetworkInsightsPathRequest.getProtocol()));
        }
        if (createNetworkInsightsPathRequest.getDestinationPort() != null) {
            request.addParameter("DestinationPort", StringUtils.fromInteger(createNetworkInsightsPathRequest.getDestinationPort()));
        }
        if (!(createNetworkInsightsPathRequestTagSpecificationsList = (SdkInternalList)createNetworkInsightsPathRequest.getTagSpecifications()).isEmpty() || !createNetworkInsightsPathRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createNetworkInsightsPathRequestTagSpecificationsListValue : createNetworkInsightsPathRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createNetworkInsightsPathRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createNetworkInsightsPathRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createNetworkInsightsPathRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createNetworkInsightsPathRequest.getClientToken()));
        PathRequestFilter filterAtSource = createNetworkInsightsPathRequest.getFilterAtSource();
        if (filterAtSource != null) {
            RequestFilterPortRange destinationPortRange;
            RequestFilterPortRange sourcePortRange;
            if (filterAtSource.getSourceAddress() != null) {
                request.addParameter("FilterAtSource.SourceAddress", StringUtils.fromString(filterAtSource.getSourceAddress()));
            }
            if ((sourcePortRange = filterAtSource.getSourcePortRange()) != null) {
                if (sourcePortRange.getFromPort() != null) {
                    request.addParameter("FilterAtSource.SourcePortRange.FromPort", StringUtils.fromInteger(sourcePortRange.getFromPort()));
                }
                if (sourcePortRange.getToPort() != null) {
                    request.addParameter("FilterAtSource.SourcePortRange.ToPort", StringUtils.fromInteger(sourcePortRange.getToPort()));
                }
            }
            if (filterAtSource.getDestinationAddress() != null) {
                request.addParameter("FilterAtSource.DestinationAddress", StringUtils.fromString(filterAtSource.getDestinationAddress()));
            }
            if ((destinationPortRange = filterAtSource.getDestinationPortRange()) != null) {
                if (destinationPortRange.getFromPort() != null) {
                    request.addParameter("FilterAtSource.DestinationPortRange.FromPort", StringUtils.fromInteger(destinationPortRange.getFromPort()));
                }
                if (destinationPortRange.getToPort() != null) {
                    request.addParameter("FilterAtSource.DestinationPortRange.ToPort", StringUtils.fromInteger(destinationPortRange.getToPort()));
                }
            }
        }
        if ((filterAtDestination = createNetworkInsightsPathRequest.getFilterAtDestination()) != null) {
            RequestFilterPortRange destinationPortRange;
            RequestFilterPortRange sourcePortRange;
            if (filterAtDestination.getSourceAddress() != null) {
                request.addParameter("FilterAtDestination.SourceAddress", StringUtils.fromString(filterAtDestination.getSourceAddress()));
            }
            if ((sourcePortRange = filterAtDestination.getSourcePortRange()) != null) {
                if (sourcePortRange.getFromPort() != null) {
                    request.addParameter("FilterAtDestination.SourcePortRange.FromPort", StringUtils.fromInteger(sourcePortRange.getFromPort()));
                }
                if (sourcePortRange.getToPort() != null) {
                    request.addParameter("FilterAtDestination.SourcePortRange.ToPort", StringUtils.fromInteger(sourcePortRange.getToPort()));
                }
            }
            if (filterAtDestination.getDestinationAddress() != null) {
                request.addParameter("FilterAtDestination.DestinationAddress", StringUtils.fromString(filterAtDestination.getDestinationAddress()));
            }
            if ((destinationPortRange = filterAtDestination.getDestinationPortRange()) != null) {
                if (destinationPortRange.getFromPort() != null) {
                    request.addParameter("FilterAtDestination.DestinationPortRange.FromPort", StringUtils.fromInteger(destinationPortRange.getFromPort()));
                }
                if (destinationPortRange.getToPort() != null) {
                    request.addParameter("FilterAtDestination.DestinationPortRange.ToPort", StringUtils.fromInteger(destinationPortRange.getToPort()));
                }
            }
        }
        return request;
    }
}

