/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractAnumMeaning;
import com.dataiku.dip.utils.FastSafePatternMatcher;
import org.apache.commons.lang.StringUtils;

public class DateSource
extends AbstractAnumMeaning {
    private static final FastSafePatternMatcher plausibleYear = new FastSafePatternMatcher("(^|[^0-9])(20[0-9]{2})|(19[0-9]{2})($|[^0-9])");
    private static final FastSafePatternMatcher somethingLikeYYMMDD = new FastSafePatternMatcher("[^/][0-9]{1,2}[-_:/]+[0-9]{1,2}[-_:/]+[0-9]{1,2}[^/]");
    private static final String somethingLikeYYMMMDDRegexp = "[0-9]{1,2}[-_:\\/]*((" + StringUtils.join((Object[])new String[]{"jan(?>uary|\\.)?", "feb(?>ruary|r?\\.?)?", "mar(?>ch|\\.)?", "apr(?>il|\\.)?", "may", "jun(?>e|\\.)?", "jul(?>y|\\.)?", "aug(?>ust|\\.)?", "sep(?>tember|t?\\.?)?", "oct(?>ober|\\.)?", "nov(?>ember|\\.)?", "dec(?>ember|\\.)?", "janv(?>ier|\\.)?", "f[\u00e9e]v(?>rier|\\.|r\\.?)?", "mars", "avr(?>il|\\.)?", "mai", "juin", "juil(?>let|\\.|l\\.?)?", "ao[u\u00fb]t", "sept(?>embre|\\.)?", "oct(?>obre|\\.)?", "nov(?>embre|\\.)?", "d[\u00e9e]c(?>embre|\\.)?"}, (String)")|(") + "))[-_:\\/]*[0-9]{1,2}";
    private static final FastSafePatternMatcher somethingLikeYYMMMDD = new FastSafePatternMatcher(somethingLikeYYMMMDDRegexp, 2);

    @Override
    public double detects(String v) {
        if (v == null) {
            return 0.0;
        }
        if (v.length() == 8 && (v.startsWith("20") || v.startsWith("19")) && StringUtils.isNumeric((String)v)) {
            int val1 = Integer.parseInt(v.substring(4, 6));
            int val2 = Integer.parseInt(v.substring(6, 8));
            if (val1 >= 1 && val1 <= 12 && val2 >= 1 && val2 <= 31 || val2 >= 1 && val2 <= 12 && val1 >= 1 && val1 <= 31) {
                return 0.27;
            }
            return 0.0;
        }
        if (v.length() <= 50) {
            if (somethingLikeYYMMMDD.getMatcher(v).find()) {
                return 0.08;
            }
            if (somethingLikeYYMMDD.getMatcher(v).find()) {
                return 0.03;
            }
            if (plausibleYear.getMatcher(v).find()) {
                return 0.011;
            }
        }
        return 0.005;
    }
}

