/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.spnego;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import net.sourceforge.spnego.SpnegoAuthenticator;
import net.sourceforge.spnego.SpnegoFilterConfig;
import net.sourceforge.spnego.SpnegoHttpServletRequest;
import net.sourceforge.spnego.SpnegoHttpServletResponse;
import net.sourceforge.spnego.SpnegoPrincipal;
import net.sourceforge.spnego.UserAccessControl;
import org.ietf.jgss.GSSException;

public final class SpnegoHttpFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger("SpnegoHttpFilter");
    private transient SpnegoAuthenticator authenticator;
    private transient UserAccessControl accessControl;
    private transient String sitewide;
    private transient String page403;
    private final transient List<String> excludeDirs = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            SpnegoFilterConfig config = SpnegoFilterConfig.getInstance(filterConfig);
            this.excludeDirs.addAll(config.getExcludeDirs());
            LOGGER.info("excludeDirs=" + this.excludeDirs);
            this.authenticator = new SpnegoAuthenticator(config);
            Properties props = SpnegoHttpFilter.toProperties(filterConfig);
            if (!props.getProperty("spnego.authz.class", "").isBlank()) {
                props.put("spnego.server.realm", this.authenticator.getServerRealm());
                this.page403 = props.getProperty("spnego.authz.403", "").trim();
                this.sitewide = props.getProperty("spnego.authz.sitewide", "").trim();
                this.sitewide = this.sitewide.isBlank() ? null : this.sitewide;
                this.accessControl = (UserAccessControl)Class.forName(props.getProperty("spnego.authz.class")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.accessControl.init(props);
            }
        }
        catch (LoginException lex) {
            throw new ServletException((Throwable)lex);
        }
        catch (GSSException gsse) {
            throw new ServletException((Throwable)gsse);
        }
        catch (PrivilegedActionException pae) {
            throw new ServletException((Throwable)pae);
        }
        catch (FileNotFoundException fnfe) {
            throw new ServletException((Throwable)fnfe);
        }
        catch (URISyntaxException uri) {
            throw new ServletException((Throwable)uri);
        }
        catch (InstantiationException iex) {
            throw new ServletException((Throwable)iex);
        }
        catch (IllegalAccessException iae) {
            throw new ServletException((Throwable)iae);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServletException((Throwable)cnfe);
        }
        catch (IllegalArgumentException iarge) {
            throw new ServletException((Throwable)iarge);
        }
        catch (InvocationTargetException ite) {
            throw new ServletException((Throwable)ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new ServletException((Throwable)nsme);
        }
        catch (SecurityException se) {
            throw new ServletException((Throwable)se);
        }
    }

    public void destroy() {
        this.page403 = null;
        this.sitewide = null;
        if (null != this.excludeDirs) {
            this.excludeDirs.clear();
        }
        if (null != this.accessControl) {
            this.accessControl.destroy();
            this.accessControl = null;
        }
        if (null != this.authenticator) {
            this.authenticator.dispose();
            this.authenticator = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SpnegoPrincipal principal;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        SpnegoHttpServletResponse spnegoResponse = new SpnegoHttpServletResponse((HttpServletResponse)response);
        if (this.exclude(httpRequest.getContextPath(), httpRequest.getServletPath(), httpRequest.getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        try {
            principal = this.authenticator.authenticate(httpRequest, spnegoResponse);
        }
        catch (GSSException gsse) {
            LOGGER.severe("HTTP Authorization Header=" + httpRequest.getHeader("Authorization"));
            throw new ServletException((Throwable)gsse);
        }
        if (spnegoResponse.isStatusSet()) {
            return;
        }
        if (null == principal) {
            LOGGER.severe("Principal was null.");
            spnegoResponse.setStatus(500, true);
            return;
        }
        LOGGER.fine("principal=" + principal);
        SpnegoHttpServletRequest spnegoRequest = new SpnegoHttpServletRequest(httpRequest, principal, this.accessControl);
        if (!this.isAuthorized((HttpServletRequest)spnegoRequest)) {
            LOGGER.info("Principal Not AuthoriZed: " + principal);
            if (this.page403.isBlank()) {
                spnegoResponse.setStatus(403, true);
            } else {
                request.getRequestDispatcher(this.page403).forward((ServletRequest)spnegoRequest, response);
            }
            return;
        }
        chain.doFilter((ServletRequest)spnegoRequest, response);
    }

    private boolean isAuthorized(HttpServletRequest request) {
        return null == this.sitewide || null == this.accessControl || this.accessControl.hasAccess(request.getRemoteUser(), this.sitewide);
    }

    private boolean exclude(String contextPath, String servletPath, String requestUri) {
        String path = contextPath + servletPath + (servletPath.endsWith("/") ? "" : "/");
        for (String dir : this.excludeDirs) {
            if (path.startsWith(dir)) {
                return true;
            }
            if (!requestUri.startsWith(dir)) continue;
            return true;
        }
        return false;
    }

    private static Properties toProperties(FilterConfig filterConfig) {
        Properties props = new Properties();
        Enumeration it = filterConfig.getInitParameterNames();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            props.put(key, filterConfig.getInitParameter(key));
        }
        return props;
    }

    public static final class Constants {
        public static final String ALLOW_BASIC = "spnego.allow.basic";
        public static final String ALLOW_DELEGATION = "spnego.allow.delegation";
        public static final String ALLOW_LOCALHOST = "spnego.allow.localhost";
        public static final String ALLOW_UNSEC_BASIC = "spnego.allow.unsecure.basic";
        public static final String AUTHN_HEADER = "WWW-Authenticate";
        public static final String AUTHZ_HEADER = "Authorization";
        public static final String BASIC_HEADER = "Basic";
        public static final String CLIENT_MODULE = "spnego.login.client.module";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String EXCLUDE_DIRS = "spnego.exclude.dirs";
        public static final String KRB5_CONF = "spnego.krb5.conf";
        static final String LOGGER_LEVEL = "spnego.logger.level";
        static final String LOGGER_NAME = "SpnegoHttpFilter";
        public static final String LOGIN_CONF = "spnego.login.conf";
        public static final String NEGOTIATE_HEADER = "Negotiate";
        static final String NTLM_PROLOG = "TlRMTVNT";
        public static final String PREAUTH_PASSWORD = "spnego.preauth.password";
        public static final String PREAUTH_USERNAME = "spnego.preauth.username";
        public static final String PROMPT_NTLM = "spnego.prompt.ntlm";
        public static final String SERVER_MODULE = "spnego.login.server.module";
        public static final String SOAP_ACTION = "SOAPAction";

        private Constants() {
        }
    }
}

