/*
 * Decompiled with CFR 0.152.
 */
package io.krakens.grok.api;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Converter {
    private static final Pattern SPLITTER = Pattern.compile("[:;]");
    private static final Map<String, Type> TYPES = Arrays.stream(Type.values()).collect(Collectors.toMap(t -> t.name().toLowerCase(), t -> t));
    private static final Map<String, Type> TYPE_ALIASES = Arrays.stream(Type.values()).flatMap(type -> type.aliases.stream().map(alias -> new AbstractMap.SimpleEntry<String, Type>((String)alias, (Type)((Object)type)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    private static Type getType(String key) {
        Type type = TYPES.getOrDefault(key = key.toLowerCase(), TYPE_ALIASES.get(key));
        if (type == null) {
            throw new IllegalArgumentException("Invalid data type :" + key);
        }
        return type;
    }

    public static Map<String, IConverter<? extends Object>> getConverters(Collection<String> groupNames, Object ... params) {
        return groupNames.stream().filter(Converter::containsDelimiter).collect(Collectors.toMap(Function.identity(), key -> {
            String[] list = Converter.splitGrokPattern(key);
            IConverter<? extends Object> converter = Converter.getType((String)list[1]).converter;
            if (list.length == 3) {
                converter = converter.newConverter(list[2], params);
            }
            return converter;
        }));
    }

    public static Map<String, Type> getGroupTypes(Collection<String> groupNames) {
        return groupNames.stream().filter(Converter::containsDelimiter).map(Converter::splitGrokPattern).collect(Collectors.toMap(l -> l[0], l -> Converter.getType(l[1])));
    }

    public static String extractKey(String key) {
        return Converter.splitGrokPattern(key)[0];
    }

    private static boolean containsDelimiter(String string) {
        return string.indexOf(58) >= 0 || string.indexOf(59) >= 0;
    }

    private static String[] splitGrokPattern(String string) {
        return SPLITTER.split(string, 3);
    }

    static class DateConverter
    implements IConverter<Instant> {
        private final DateTimeFormatter formatter;
        private final ZoneId timeZone;

        public DateConverter() {
            this.formatter = DateTimeFormatter.ISO_DATE_TIME;
            this.timeZone = ZoneOffset.UTC;
        }

        private DateConverter(DateTimeFormatter formatter, ZoneId timeZone) {
            this.formatter = formatter;
            this.timeZone = timeZone;
        }

        @Override
        public Instant convert(String value) {
            TemporalAccessor dt = this.formatter.parseBest(value.trim(), ZonedDateTime::from, LocalDateTime::from, OffsetDateTime::from, Instant::from, LocalDate::from);
            if (dt instanceof ZonedDateTime) {
                return ((ZonedDateTime)dt).toInstant();
            }
            if (dt instanceof LocalDateTime) {
                return ((LocalDateTime)dt).atZone(this.timeZone).toInstant();
            }
            if (dt instanceof OffsetDateTime) {
                return ((OffsetDateTime)dt).atZoneSameInstant(this.timeZone).toInstant();
            }
            if (dt instanceof Instant) {
                return (Instant)dt;
            }
            if (dt instanceof LocalDate) {
                return ((LocalDate)dt).atStartOfDay(this.timeZone).toInstant();
            }
            return null;
        }

        public DateConverter newConverter(String param, Object ... params) {
            if (params.length != 1 || !(params[0] instanceof ZoneId)) {
                throw new IllegalArgumentException("Invalid parameters");
            }
            return new DateConverter(DateTimeFormatter.ofPattern(param), (ZoneId)params[0]);
        }
    }

    static interface IConverter<T> {
        public T convert(String var1);

        default public IConverter<T> newConverter(String param, Object ... params) {
            return this;
        }
    }

    public static enum Type {
        BYTE(Byte::valueOf, new String[0]),
        BOOLEAN(Boolean::valueOf, new String[0]),
        SHORT(Short::valueOf, new String[0]),
        INT(Integer::valueOf, "integer"),
        LONG(Long::valueOf, new String[0]),
        FLOAT(Float::valueOf, new String[0]),
        DOUBLE(Double::valueOf, new String[0]),
        DATETIME(new DateConverter(), "date"),
        STRING(v -> v, "text");

        public final IConverter<? extends Object> converter;
        public final List<String> aliases;

        private Type(IConverter<? extends Object> converter, String ... aliases) {
            this.converter = converter;
            this.aliases = Arrays.asList(aliases);
        }
    }
}

